import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class FxColorExample1 extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	public void start(Stage stage)
	{
		// Create the Colors
		Color red = new Color(1.0, 0.0, 0.0, 1.0);
		Color green = Color.web("rgb(0, 255, 0)");
		Color blue = Color.web("0X0000FF");

		// Create the Rectangles
		Rectangle rectangle1 = new Rectangle(250,100);
		Rectangle rectangle2 = new Rectangle(250,100);
		Rectangle rectangle3 = new Rectangle(250,100);

		// Set the Color of the Rectangle
		rectangle1.setFill(red);
		rectangle2.setFill(green);
		rectangle3.setFill(blue);

		// Create the VBox
		VBox root = new VBox();
		// Add the details to the VBox
		root.getChildren().addAll(rectangle1,rectangle2,rectangle3);
		// Set the vertical spacing between children to 10px
		root.setSpacing(10);

		// Set the Style-properties of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root,300,400);
		// Add the scene to the Stage
		stage.setScene(scene);
		// Set the title of the Stage
		stage.setTitle("A simple Color Example");
		// Display the Stage
		stage.show();
	}
}
