<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Wisdom Blog
 * @subpackage Wisdom Minimal
 * @since 1.0.0
 */

get_header();
?>
<div class="cv-content-wrapper">
	<section id="primary" class="content-area">
		<main id="main" class="site-main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1 class="page-title">
					<?php
					/* translators: %s: search query. */
					printf( esc_html__( 'Search Results for: %s', 'wisdom-minimal' ), '<span>' . get_search_query() . '</span>' );
					?>
				</h1>
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'template-parts/content', get_post_type() );

			endwhile;

			$wisdom_minimal_archive_pagination = get_theme_mod( 'wisdom_minimal_archive_pagination', 'default' );
			if( $wisdom_minimal_archive_pagination == 'default' ) {
				the_posts_navigation();
			} else {
				the_posts_pagination();
			}

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>

		</main><!-- #main -->
	</section><!-- #primary -->

    <?php wisdom_blog_get_sidebar(); ?>
</div><!-- .cv-content-wrapper -->

<?php
get_footer();