<?php
if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="custom-header" id="custom-header" rel="home">
		<img src="<?php echo get_header_image(); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>
<?php endif; ?>

<!--===// Start: Header
        =================================-->
<header id="header-section" class="header header-three">
<!--===// Start: Header Above
	=================================-->
	<?php do_action('webora_above_header'); ?>
	<!--===// End: Header Top
	=================================-->
	
	<div class="navigator-wrapper">
		<!--===// Start: Navigation
		=================================-->
			<div class="nav-area d-av-block ">
				<div class="navbar-area <?php echo webique_sticky_menu(); ?>">
					<div class="av-container">
						<div class="d-flex align-items-center justify-content-center"> 
							<div class="logo">
								<?php do_action('webique_logo_content'); ?>
							</div>
							<span class="center-home-icone">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="icon-bounce wave-effect"><i class="fa fa-home"></i></a> 
							</span>
							<div class="theme-menu">
								<nav class="menubar" id="AVMenu">
									<div class="logo">
										<?php do_action('webique_logo_content'); ?>
									</div>
									<?php do_action('webique_primary_navigation'); ?>                      
								</nav>
								<div class="menu-right">
									<ul class="header-wrap-right">
										<?php do_action('webique_navigation_search'); ?>											
										<?php do_action('webique_navigation_cart'); ?>
										
										<?php 
											$hide_show_nav_btn2 	= get_theme_mod( 'hide_show_nav_btn2','1');
											$nav_btn2_icon 			= get_theme_mod( 'nav_btn2_icon','fa-user');
											$nav_btn2_lbl 				= get_theme_mod( 'nav_btn2_lbl');
											$nav_btn2_link 				= get_theme_mod( 'nav_btn2_link');
											$hdr_btn2_newtab 		= get_theme_mod( 'hdr_btn2_newtab','1');
											$hdr_btn2_nofollow 	= get_theme_mod( 'hdr_btn2_nofollow','1');
											if($hide_show_nav_btn2 =='1'  && !empty($nav_btn2_lbl)): 
										?>
										<li class="about-toggle-list">
											<div class="contact-area hdr-btn-2 text-right">
												<a href="<?php echo esc_url($nav_btn2_link); ?>" class="av-btn av-btn-primary av-btn-bubble rounded-pill" <?php if($hdr_btn2_newtab =='yes') {echo 'target="_blank"'; } ?> rel="<?php if($hdr_btn2_newtab =='yes') {echo 'noreferrer noopener';} ?> <?php if($hdr_btn2_nofollow =='yes') {echo 'nofollow';} ?>"><?php echo wp_kses_post($nav_btn2_lbl); ?></a>
                                            </div>
										</li>
										<?php endif; ?>
										
										<li class="about-toggle-list d-lg-none">
											<div class="hamburger hamburger-menu">
												<button type="button" class="toggle-lines menu-toggle" data-target="#AVMenu">
													<div class="top-bun"></div>
													<div class="meat"></div>
													<div class="bottom-bun"></div>
												</button>
												<div class="menu-close fade-overlay"></div>
											</div>
										</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<!--===// End:  Navigation
		=================================-->
	</div>
</header>
 <!-- End: Header
        =================================-->

<?php
	if ( !is_page_template( 'templates/template-homepage.php' ) ) {
		webique_breadcrumbs_style();  
	}	
?>