<?php
/**
 * Contains methods for customizing the theme customization screen.
 * @link http://codex.wordpress.org/Theme_Customization_API
 */
 
class typist_Customize {
   /**
    * This hooks into 'customize_register' and allows
    * you to add new sections and controls to the Theme Customize screen.
    */
   public static function typist_register ( $wp_customize ) {

        // Breadcrumbs pro
        $wp_customize->add_section( 'typist_breadcrumbs' , array(
        'title'      => __( 'Breadcrumbs', 'typist' ),
        'priority'   => 30,
        ));
		
        // Container Width
        $wp_customize->add_section( 'typist_container_width' , array(
        'title'      => __( 'Width', 'typist' ),
        'priority'   => 30,
        ));

        // Social Accounts
        $wp_customize->add_section( 'typist_social_section' , array(
        'title'      => __( 'Social Accounts', 'typist' ),
        'description' => __( '<strong>Enter full URL with http://</strong><br/> Leave empty to disable.', 'typist' ),
        'priority'   => 35,
        ));
		
        // Layout
        $wp_customize->add_section( 'typist_layout', array(
        'title'      => __('Layout', 'typist'),
        'priority'   => 40,
        ));
		
        // Font Options
        $wp_customize->add_section( 'typist_fonts' , array(
        'title'      => __( 'Fonts', 'typist' ),
        'priority'   => 50,
        ));

        // Featured Image
        $wp_customize->add_section( 'typist_fimage' , array(
        'title'      => __( 'Featured Image', 'typist' ),
        'priority'   => 55,
        ));
		
        // Meta Options
        $wp_customize->add_section( 'typist_meta' , array(
        'title'      => __( 'Meta Information', 'typist' ),
        'priority'   => 60,
        ));

        // -----------------------------------------------------------------------------

        /**
        * Show/Hide featured image - list
        */
        $wp_customize->add_setting( 'typist_show_fimage', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_fimage',
          array(
            'description' => __( 'Shows the post featured image at the top of every post, below heading on blog list pages.', 'typist' ),
            'type' => 'checkbox',
            'label' => __( 'Show featured image in blog', 'typist' ),
            'section' => 'typist_fimage',
            'std' => '0',
        ));
        // -----------------------------------------------------------------------------
   
        /**
        * Show/Hide featured image - single
        */
        $wp_customize->add_setting( 'typist_show_fimages', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_fimages',
          array(
            'description' => __( 'Shows the post featured image at the top of the post in single post.', 'typist' ),
            'type' => 'checkbox',
            'label' => __( 'Show featured image in post', 'typist' ),
            'section' => 'typist_fimage',
            'std' => '0',
        ));
        // -----------------------------------------------------------------------------

        /**
        * Show/Hide meta for posts
        */
        $wp_customize->add_setting( 'typist_show_meta', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_meta',
          array(
            'description' => __( 'Both single and blog views', 'typist' ),
            'type' => 'checkbox',
            'label' => __( 'HIDE ALL meta info for posts', 'typist' ),
            'section' => 'typist_meta',
            'std' => '0',
        ));
        // -----------------------------------------------------------------------------

        /**
        * Show/Hide meta for pages
        */
        $wp_customize->add_setting( 'typist_show_meta_pages', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_meta_pages',
          array(
            'type' => 'checkbox',
            'label' => __( 'HIDE ALL meta info for pages', 'typist' ),
            'section' => 'typist_meta',
            'std' => '0',
        ));
        // -----------------------------------------------------------------------------
		
        /**
        * Show/Hide categories on posts
        */
        $wp_customize->add_setting( 'typist_show_cat', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_cat',
          array(
            'type' => 'checkbox',
            'label' => __( 'Hide categories in meta info', 'typist' ),
            'section' => 'typist_meta',
            'std' => '1',
        ));
        // -----------------------------------------------------------------------------

        /**
        * Show/Hide date on posts
        */
        $wp_customize->add_setting( 'typist_show_date', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_date',
          array(
            'type' => 'checkbox',
            'label' => __( 'Hide date in meta info', 'typist' ),
            'section' => 'typist_meta',
        ));
        // -----------------------------------------------------------------------------
       
	    /**
        * Show/Hide tags on posts
        */
        $wp_customize->add_setting( 'typist_show_tags', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_tags',
          array(
            'type' => 'checkbox',
            'label' => __( 'Hide tags in meta info', 'typist' ),
            'section' => 'typist_meta',
        ));
        // -----------------------------------------------------------------------------
	    
		/**
        * Show/Hide comment count on posts
        */
        $wp_customize->add_setting( 'typist_show_comm', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_show_comm',
          array(
            'type' => 'checkbox',
            'label' => __( 'Hide comment link in meta info', 'typist' ),
            'section' => 'typist_meta',
        ));
        // -----------------------------------------------------------------------------
		
		/**
        * Show/Hide author on posts
        */
        $wp_customize->add_setting( 'typist_autho', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control(
          'typist_autho',
          array(
            'type' => 'checkbox',
            'label' => __( 'Hide author in meta info', 'typist' ),
            'section' => 'typist_meta',
        ));
        // -----------------------------------------------------------------------------

		/*
        * Color scheme
        */
        $wp_customize->add_setting('typist_blogscheme', array(
            'default'        => 'cherry',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_scheme'
        ));

        $wp_customize->add_control('typist_blogscheme', array(
            'label'      => __('Choose color scheme', 'typist'),
            'section'    => 'colors',
            'settings'   => 'typist_blogscheme',
            'description' => '',
            'type'       => 'radio',
            'choices'    => array(
                'cherry'	=>	__('Cherry', 'typist'),
                'greyscale'	=>	__('Greyscale', 'typist'),
                'mono'	=>		__('Monochrome', 'typist'),
                'dark'   =>	__('Dark', 'typist'),
                'terminal'   =>	__('Terminal', 'typist'),
                'beige'   =>	__('Beige', 'typist'),
                'gum'   =>	__('Bubblegum', 'typist'),
				'custom'   =>	__('Custom (choose below)', 'typist')
                ),
        ));
        // -----------------------------------------------------------------------------
		//PRO custom colors start	
        
		/**
        * Primary color
        */
        $wp_customize->add_setting( 'primary_color' , array(
            'default'     => '#30000e',
            'sanitize_callback' => 'sanitize_hex_color',
            ));

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'typist_primary_color', array(
            'label'        => __( 'Text Color', 'typist' ),
            'section'    => 'colors',
            'settings'   => 'primary_color',
        )));
        // -----------------------------------------------------------------------------
		
        /*
        * Heading Link Color
        */ 
        $wp_customize->add_setting( 'heading_linkcolor', 
            array(
                'default' => '#30000e', 
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'sanitize_callback' => 'sanitize_hex_color',
            ) 
        );      
            
        $wp_customize->add_control( new WP_Customize_Color_Control( 
            $wp_customize, 
            'typist_heading_linkcolor',
            array(
                'label' => __( 'Headings Color', 'typist' ), 
                'section' => 'colors', 
                'settings' => 'heading_linkcolor', 
                'priority' => 10,
            ) 
        ));
        // -----------------------------------------------------------------------------

		/**
        * Social icons color
        */
        $wp_customize->add_setting( 'typist_social_color' , array(
            'default'     => '#30000e',
            'sanitize_callback' => 'sanitize_hex_color',
            ));

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'typist_social_color', array(
            'label'        => __( 'Social Icons Color', 'typist' ),
            'section'    => 'colors',
            'settings'   => 'typist_social_color',
        )));
        // -----------------------------------------------------------------------------
	    
		/**
        * Menu color
        */
        $wp_customize->add_setting( 'typist_menu_color' , array(
            'default'     => '#999',
            'sanitize_callback' => 'sanitize_hex_color',
            ));

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'typist_menu_color', array(
            'label'        => __( 'Menu Color', 'typist' ),
            'section'    => 'colors',
            'settings'   => 'typist_menu_color',
        )));
        // -----------------------------------------------------------------------------

		/**
        * Menu text color
        */
        $wp_customize->add_setting( 'typist_menutext_color' , array(
            'default'     => '#fff',
            'sanitize_callback' => 'sanitize_hex_color',
            ));

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'typist_menutext_color', array(
            'label'        => __( 'Menu Links Color', 'typist' ),
            'section'    => 'colors',
            'settings'   => 'typist_menutext_color',
        )));
        // -----------------------------------------------------------------------------
				        
		/*
        * Link Color
        */ 
        $wp_customize->add_setting( 'link_textcolor', 
            array(
            'default' => '#999',
            'sanitize_callback' => 'sanitize_hex_color',
        ));           

        $wp_customize->add_control( new WP_Customize_Color_Control( 
            $wp_customize, 
            'typist_link_textcolor', 
            array(
            'label' => __( 'Links Color', 'typist' ), 
            'section' => 'colors', 
            'settings' => 'link_textcolor', 
            'priority' => 10, 
            ) 
        ));     
	    // -----------------------------------------------------------------------------
      
	    /**
        * Link hover color
        */
        $wp_customize->add_setting( 'hover_color' , array(
            'default'     => '#aa264b',
            'sanitize_callback' => 'sanitize_hex_color',
            ));

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'typist_hover_color', array(
            'label'        => __( 'Hover Color', 'typist' ),
            'section'    => 'colors',
            'settings'   => 'hover_color',
        )));
        // -----------------------------------------------------------------------------	
// PRO custom colors end 
 
		/*
        * Blog Layout
        */
        $wp_customize->add_setting('typist_bloglayout', array(
            'default'        => 'left',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_layout',
        ));

        $wp_customize->add_control('typist_option_bloglayout', array(
            'label'      => __('Blog layout', 'typist'),
            'section'    => 'typist_layout',
            'settings'   => 'typist_bloglayout',
            'description' => '',
            'type'       => 'radio',
            'choices'    => array(
                'left' => __('Left Sidebar', 'typist'),
                'full_width' => __('Full Width / No sidebar', 'typist'),
                'right'   => __('Right Sidebar', 'typist')
                ),
        ));
        // -----------------------------------------------------------------------------
        
		/*
        * Post Layout
        */
        $wp_customize->add_setting('typist_postlayout', array(
            'default'        => 'left',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_layout',
        ));

        $wp_customize->add_control('typist_option_postlayout', array(
            'label'      => __('Single post layout', 'typist'),
            'section'    => 'typist_layout',
            'settings'   => 'typist_postlayout',
            'description' => '',
            'type'       => 'radio',
            'choices'    => array(
                'left' => __('Left Sidebar', 'typist'),
                'full_width' => __('Full Width / No sidebar', 'typist'),
                'right'   => __('Right Sidebar', 'typist')
                ),
        ));
        // -----------------------------------------------------------------------------
       
	    /*
        * Page Layout
        */
        $wp_customize->add_setting('typist_pagelayout', array(
            'default'        => 'left',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_layout',
        ));

        $wp_customize->add_control('typist_option_pagelayout', array(
            'label'      => __('Single page layout', 'typist'),
            'section'    => 'typist_layout',
            'settings'   => 'typist_pagelayout',
            'description' => '',
            'type'       => 'radio',
            'choices'    => array(
                'left' => __('Left Sidebar', 'typist'),
                'full_width' => __('Full Width / No sidebar', 'typist'),
                'right'   => __('Right Sidebar', 'typist')
                ),
        ));
        // -----------------------------------------------------------------------------
        
		/**
        * Site width
        */
        $wp_customize->add_setting('container_width', array(
            'default'        => '1400px',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_width',
            ));

        $wp_customize->add_control('typist_option_container_width', array(
            'label'      => __('Width', 'typist'),
            'section'    => 'typist_container_width',
            'settings'   => 'container_width',
            'description' => __('Choose max site width (in pixels).', 'typist'),
            'type'       => 'radio',
            'choices'    => array(
			    '980px' => __('980', 'typist'),
                '1280px' => __('1280', 'typist'),
                '1400px' => __('1400', 'typist'),
                '1600px' => __('1600', 'typist'),
                '1920px' => __('1920', 'typist')
                ),
        ));
        // -----------------------------------------------------------------------------
 
	    /**
        Facebook
        */
        $wp_customize->add_setting('typist_social_facebook', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'transport' => 'postMessage', 
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_social_facebook', array(
            'label'      => __('Facebook', 'typist'),
            'section'    => 'typist_social_section',
            'settings'   => 'typist_social_facebook'
        ));
        // ----------------------------------------------------------------------------- 	

	    /**
        Instagram
        */
        $wp_customize->add_setting('typist_social_instagram', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_social_instagram', array(
            'label'      => __('Instagram', 'typist'),
            'section'    => 'typist_social_section',
            'settings'   => 'typist_social_instagram'
        ));
        // -----------------------------------------------------------------------------  

	    /**
        Twitter
        */
        $wp_customize->add_setting('typist_social_twitter', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_social_twitter', array(
            'label'      => __('Twitter', 'typist'),
            'section'    => 'typist_social_section',
            'settings'   => 'typist_social_twitter'
        ));
        // -----------------------------------------------------------------------------		

	    /**
        Youtube
        */
        $wp_customize->add_setting('typist_social_youtube', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_social_youtube', array(
            'label'      => __('YouTube', 'typist'),
            'section'    => 'typist_social_section',
            'settings'   => 'typist_social_youtube'
        ));
        // -----------------------------------------------------------------------------
		
	    /**
        Google plus
        */
        $wp_customize->add_setting('typist_social_googleplus', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_social_googleplus', array(
            'label'      => __('Google +', 'typist'),
            'section'    => 'typist_social_section',
            'settings'   => 'typist_social_googleplus'
        ));
        // -----------------------------------------------------------------------------
		
	    /**
       	Pinterest
        */
        $wp_customize->add_setting('typist_social_pinterest', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_social_pinterest', array(
            'label'      => __('Pinterest', 'typist'),
            'section'    => 'typist_social_section',
            'settings'   => 'typist_social_pinterest'
        ));
        // -----------------------------------------------------------------------------
		
	    /**
        Vk.com
        */
        $wp_customize->add_setting('typist_social_vk', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_social_vk', array(
            'label'      => __('Vk.com', 'typist'),
            'section'    => 'typist_social_section',
            'settings'   => 'typist_social_vk'
        ));
        // -----------------------------------------------------------------------------				
      
	    /**
        * Headings
        */
        $wp_customize->add_setting('typist_headings_font', array(
            'default'        => 'Fjalla One',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_fontfamily',
            ));

        $wp_customize->add_control('typist_headings_font', array(
            'label'      => __('Headings Font', 'typist'),
            'section'    => 'typist_fonts',
            'settings'   => 'typist_headings_font',
            'type'       => 'select',
            'choices'    => array(
				'Fjalla One' => 'Fjalla One', 
                'Oswald' => 'Oswald',
                'Francois One' => 'Francois One',
				'Yanone Kaffeesatz' => 'Yanone Kaffeesatz',
                'Roboto Slab' => 'Roboto Slab',		
                'BenchNine' => 'BenchNine',
                'Passion One' => 'Passion One',		
                'Open Sans' => 'Open Sans',
                'Noto Serif' => 'Noto Serif',
                'Noto Sans' => 'Noto Sans',
				'PT Sans' => 'PT Sans',
				'Fira Sans' => 'Fira Sans',	
                'Arial' => 'Arial',
                'Verdana' => 'Verdana',
                'Times New Roman' => 'Times New Roman',
                'Monospace' => 'Monospace',
                'Impact' => 'Impact'
				),
        ));
        // -----------------------------------------------------------------------------	
      
	    /**
        * Body Font
        */
        $wp_customize->add_setting('typist_body_font', array(
            'default'        => 'Noto Sans',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_fontfamily',
            ));

        $wp_customize->add_control('typist_body_font', array(
            'label'      => __('Body Font', 'typist'),
            'section'    => 'typist_fonts',
            'settings'   => 'typist_body_font',
            'type'       => 'select',
            'choices'    => array(
                'Noto Sans' => 'Noto Sans',
                'Noto Serif' => 'Noto Serif',
                'Open Sans' => 'Open Sans',
				'PT Sans' => 'PT Sans',
                'Roboto Slab' => 'Roboto Slab',	
				'Fira Sans' => 'Fira Sans',	
                'Arial' => 'Arial',
                'Verdana' => 'Verdana',
                'Times New Roman' => 'Times New Roman',
                'Monospace' => 'Monospace',
			    'Impact' => 'Impact'
				),
        ));	
        // -----------------------------------------------------------------------------	
       
	    /**
        * Headings

        */
        $wp_customize->add_setting('typist_headings_weight', array(
            'default'        => '400',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'transport' => 'postMessage', 
            'sanitize_callback' => 'typist_sanitize_weight',
            ));

        $wp_customize->add_control('typist_headings_weight', array(
            'label'      => __('Headings weight', 'typist'),
            'section'    => 'typist_fonts',
            'settings'   => 'typist_headings_weight',
            'description' => __('Bold or normal headings?', 'typist'),
            'type'       => 'select',
            'choices'    => array(
                '400' => __('Normal', 'typist'),
                '800' => __('Bold', 'typist'),
                ),
            ));	
        // -----------------------------------------------------------------------------

	    /**
        * Headings
        */
        $wp_customize->add_setting( 'typist_upper', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
        ));

        $wp_customize->add_control('typist_upper', array(
            'type' => 'checkbox',
            'label' => __( 'Transform all headings to UPPERCASE', 'typist' ),
            'section' => 'typist_fonts',
            'std' => '0',
        ));
        // -----------------------------------------------------------------------------		 
        
	    /**
        logo (or title) alignment
        */
        $wp_customize->add_setting('logo_alignment', array(
            'default'        => 'left',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'sanitize_callback' => 'typist_sanitize_align',
            ));

        $wp_customize->add_control('typist_logo_alignment', array(
            'label'      => __('Logo/Title alignment', 'typist'),
            'section'    => 'title_tagline', 
            'settings'   => 'logo_alignment',
            'description' => __( 'Where will the logo be?', 'typist' ),
            'type'       => 'radio',
            'choices'    => array(
                'left' => __( 'Left', 'typist' ),
                'center' => __( 'Center', 'typist' ),
                'right' => __( 'Right', 'typist' ),
                ),
            ));	
        // -----------------------------------------------------------------------------
 
        /**
        * Breadcrumps
        */
        $wp_customize->add_setting( 'typist_show_breadcrumbs', array(
            'sanitize_callback' => 'typist_sanitize_checkbox',
			'default'        => 1
        ));

        $wp_customize->add_control(
          'typist_show_breadcrumbs',
          array(
            'description' => __( 'Displays breadcrumbs navigation (where possible)', 'typist' ),
            'type' => 'checkbox',
            'label' => __( 'Show breadcrumbs', 'typist' ),
            'section' => 'typist_breadcrumbs'
        ));
        // -----------------------------------------------------------------------------
		      
	    /**
        footer copyright text
        */
        $wp_customize->add_setting('footer_copyright', array(
            'default'        => '',
            'capability'     => 'edit_theme_options',
            'type'           => 'theme_mod',
            'transport'      => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
            ));

        $wp_customize->add_control('typist_footer_copyright', array(
            'label'      => __('Footer Copyright', 'typist'),
            'section'    => 'title_tagline',
            'settings'   => 'footer_copyright'
        ));
        // -----------------------------------------------------------------------------           

		//Theme support Section
		$wp_customize->add_section( 'typist_pro_add', array(
			  'priority'       => 1001,
			  'title'          => __('Theme Support', 'typist'),
			  'description'    => __('<p>
			 Thank you for using the Typist theme! I hope you like it.</p><p>
			 			 <p>Visit the theme website to download the child theme for the Typist theme. If you find my themes useful, you can support their development by donating any amount you like ♥.</p>
			 In case you have any questions or requests, please visit the support forums:</p>
			  <h2 style="padding-left:10px;"><a href="https://tavi.ws/typist-wordpress-theme/">Support page</a>
			  </h2>
			  ', 'typist'),
			));
		// -----------------------------------------------------------------------------
		$wp_customize->add_setting('typist_pro_info', array(
          'sanitize_callback' => 'sanitize_text_field',
		  'type' => 'info_control',
		  'capability' => 'edit_theme_options',
		  )
		);
		$wp_customize->add_control( 'typist_pro_info_control', array(
			'section' => 'typist_pro_add',
			'settings' => 'typist_pro_info',
			'priority' => 10,
            'type'       => 'radio',
			'style' => 'display: none;',
			)
		);
		// ----------------------------------------------------------------------------- 

		// Stuff that uses live preview JS
        $wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
        $wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
        $wp_customize->get_setting( 'typist_headings_weight' )->transport = 'postMessage';
   }

   /**
    * This will output the custom WordPress settings to the live theme's WP head.
    * Used by hook: 'wp_head'
    */
   public static function typist_header_output() {
      ?>
      <!--Customizer CSS--> 
      <style type="text/css">
 
		  <?php 			
		  if (get_theme_mod('typist_show_date') == '1'){ ?>
			  .s_date {display: none;} <?php }		
		  if (get_theme_mod('typist_show_tags') == '1'){ ?>
			  .s_tags {display: none;} <?php }			
		  if (get_theme_mod('typist_show_cat') == '1'){ ?>
			  .s_category {display: none;} <?php }		
		  if (get_theme_mod('typist_show_comm') == '1'){ ?>
			  .s_comm {display: none;} <?php }		
		  if (get_theme_mod('typist_autho') == '1'){ ?>
			  .s_auth {display: none;} <?php } 	
		  if (get_theme_mod('typist_upper') == '1'){ ?>
			  h1 a, h2 a, h3 a, h4 a, h5 a, h6 a, h1, h2, h3, h4, h5, h6, .site-description, .comment-author .fn {text-transform:uppercase;}<?php }
self::typist_generate_css('#logo', 'text-align', 'logo_alignment');  
self::typist_generate_css('.tlo', 'max-width', 'container_width');
self::typist_generate_css('body, input, select, textarea, .site-description', 'font-family', 'typist_body_font');
self::typist_generate_css('h1 a, h2 a, h3 a, h4 a, h5 a, h6 a, h1, h2, h3, h4, h5, h6, .comments-title, .nav-links, .page-links', 'font-family', 'typist_headings_font');
self::typist_generate_css('h1 a, h2 a, h3 a, h4 a, h5 a, h6 a, h1, h2, h3, h4, h5, h6, .site-description', 'font-weight', 'typist_headings_weight');

//PRO CUSTOM COLORS
if (get_theme_mod('typist_blogscheme') == 'custom'){ 

self::typist_generate_css('#custom #logo h1 a, body#custom, #custom input, #custom select, #custom textarea, #custom .postline, #custom footer.postline a, #custom .archive-title, #custom .format-status .postcontent, #custom .format-quote .postcontent .quote, #custom .fa-quote-left, #custom .reply, #custom .reply a, #custom .comment-meta a, #custom #menuline li li a, #custom #menuline li li a:hover, #custom .postline','color','primary_color');
self::typist_generate_css('#custom a, #custom #menuline li li a:hover','color','link_textcolor');
self::typist_generate_css('#custom #menuline a::before','border-color','link_textcolor');
self::typist_generate_css('#custom h1 a, #custom h2 a, #custom h3 a, #custom h4 a, #custom h5 a, #custom h6 a','color','heading_linkcolor');
self::typist_generate_css('#custom #menuline','background-color','typist_menu_color');
self::typist_generate_css('#custom a:active, #custom a:focus, #custom a:hover, #custom footer.postline a:hover','color','hover_color');
self::typist_generate_css('#custom #menuline li a, #custom #menuline a:hover','color','typist_menutext_color');
self::typist_generate_css('#custom .toggles a, #custom .toggles a:link, #custom .toggles a:visited, #custom .menu-toggle .fa-bars.active:before, #custom .toggles a:visited, #custom .toggles a, #custom .toggles a:link','color','typist_social_color');

}
//PRO CUSTOM COLORS

?>
 	
      </style> 
      <!--/Customizer CSS-->
      <?php
   }
   
   /**
   Outputs the javascript needed to automate the live settings preview.
    */
   public static function typist_live_preview() {
      wp_enqueue_script( 'theme-customizer', get_template_directory_uri() . '/bit/theme-customizer.js', array(  'jquery', 'customize-preview' ), '', true);
   }

    /**
	Generate a line of CSS for use in header output. If the setting ($mod_name) has no defined value, the CSS will not be output.
     */
   public static function typist_generate_css( $selector, $style, $mod_name, $prefix='', $postfix='', $echo=true ) {
	$return = '';
	$mod = esc_attr( get_theme_mod($mod_name) );
      if ( ! empty( $mod ) ) {
         $return = sprintf('%s { %s:%s; }',
            $selector,
            $style,
            $prefix.$mod.$postfix
         );
         if ( $echo ) {
            echo $return;
         }
      }
      return $return;
    }
}

// Setup the Theme Customizer settings and controls...
add_action( 'customize_register' , array( 'typist_Customize' , 'typist_register' ) );

// Output custom CSS to live site
add_action( 'wp_head' , array( 'typist_Customize' , 'typist_header_output' ) );

// Enqueue live preview javascript in Theme Customizer admin screen
add_action( 'customize_preview_init' , array( 'typist_Customize' , 'typist_live_preview' ) );
?>