<?php
/**
 * Theme functions and definitions
 *
 */

/**
 * Enqueues Styles
 */
function twister_blog_enqueue_styles() {

	wp_enqueue_style( 'twister-blog-style-parent', get_template_directory_uri() . '/style.css',
		array(
			'blog-storm-blocks',
		)
	);
}
add_action( 'wp_enqueue_scripts', 'twister_blog_enqueue_styles', 10 );


require get_stylesheet_directory() . '/inc/customizer.php';

require get_stylesheet_directory() . '/inc/child-functions.php';

add_filter( 'blog_storm_get_fonts_url', 'twister_blog_modify_font' );
/**
 * Modify enqueued font
 */
function twister_blog_modify_font( $font ){
	return str_replace( 'Jost', 'Lora', $font);
}

/**
 * Register sidebar
 */
function twister_blog_widgets_init() {
	register_sidebar( 
		array(
			'name'          => esc_html__( 'Sidebar', 'twister-blog' ),
			'id'            => 'sidebar-8',
			'description'   => esc_html__( 'Add widgets here.', 'twister-blog' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) 
	);
}
add_action( 'widgets_init', 'twister_blog_widgets_init' );

add_theme_support( "title-tag" );
add_theme_support( 'automatic-feed-links' );