<?php
/**
 * Title: Full-width feature section with headings, text, and buttons.
 * Slug: tove/general-feature-large
 * Categories: tove-general
 */
?>
<!-- wp:cover {"overlayColor":"secondary","align":"full"} -->
<div class="wp-block-cover alignfull has-secondary-background-color has-background-dim">
	<div class="wp-block-cover__inner-container">
		<!-- wp:group {"align":"wide","layout":{"inherit":true}} -->
		<div class="wp-block-group alignwide">
			<!-- wp:columns {"align":"wide","textColor":"foreground"} -->
			<div class="wp-block-columns alignwide has-foreground-color has-text-color">
				<!-- wp:column {"width":"560px"} -->
				<div class="wp-block-column" style="flex-basis:560px">
					<!-- wp:heading {"level":6,"backgroundColor":"senary"} -->
					<h6 class="has-senary-background-color has-background">Coffee on the quick</h6>
					<!-- /wp:heading -->

					<!-- wp:heading {"level":1,"style":{"typography":{"fontWeight":"500"}}} -->
					<h1 style="font-weight:500">Say Hi to the New Niofika Café App</h1>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"fontSize":"large"} -->
					<p class="has-large-font-size">It's Monday morning, you're running late to the office, but you need your morning cup of coffee to wake up before the first meeting, and the line at Niofika is loooong. Sounds familiar?</p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"fontSize":"large"} -->
					<p class="has-large-font-size">With the new <strong>Niofika Café app</strong>, you can preorder your coffee and have it ready by a time of your choosing. Pay directly in the app and skip the lines. Download it now!</p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button -->
						<div class="wp-block-button"><a class="wp-block-button__link">For iPhone</a></div>
						<!-- /wp:button -->

						<!-- wp:button -->
						<div class="wp-block-button"><a class="wp-block-button__link">For Android</a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:column -->

				<!-- wp:column {"verticalAlignment":"center"} -->
				<div class="wp-block-column is-vertically-aligned-center">
					<!-- wp:image {"align":"center","width":256,"height":308,"sizeSlug":"large","linkDestination":"none","className":"is-style-default"} -->
					<div class="wp-block-image is-style-default">
						<figure class="aligncenter size-large is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/illustrations/logo.png" alt="" width="256" height="308" /></figure>
					</div>
					<!-- /wp:image -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:group -->
	</div>
</div>
<!-- /wp:cover -->