<?php
/**
 * Tish4 functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */

/**
 * Set a constant that holds the theme's minimum supported PHP version.
 */
define( 'TISH4_MIN_PHP_VERSION', '7.0' );

/**
 * Immediately after theme switch is fired we we want to check php version and
 * revert to previously active theme if version is below our minimum.
 */
add_action( 'after_switch_theme', 'tish4_test_for_min_php' );

/**
 * Switches back to the previous theme if the minimum PHP version is not met.
 */
function tish4_test_for_min_php() {

	// Compare versions.
	if ( version_compare( PHP_VERSION, TISH4_MIN_PHP_VERSION, '<' ) ) {
		// Site doesn't meet themes min php requirements, add notice...
		add_action( 'admin_notices', 'tish4_min_php_not_met_notice' );
		// ... and switch back to previous theme.
		switch_theme( get_option( 'theme_switched' ) );
		return false;

	};
}

if ( ! function_exists( 'wp_body_open' ) ) {
        function wp_body_open() {
                do_action( 'wp_body_open' );
        }
}

/**
 * An error notice that can be displayed if the Minimum PHP version is not met.
 */
function tish4_min_php_not_met_notice() {
	?>
	<div class="notice notice-error is_dismissable">
		<p>
			<?php esc_html_e( 'You need to update your PHP version to run this theme.', 'tish4' ); ?> <br />
			<?php
			printf(
				/* translators: 1 is the current PHP version string, 2 is the minmum supported php version string of the theme */
				esc_html__( 'Actual version is: %1$s, required version is: %2$s.', 'tish4' ),
				PHP_VERSION,
				TISH4_MIN_PHP_VERSION
			); // phpcs: XSS ok.
			?>
		</p>
	</div>
	<?php
}


function tish4_enqueue_styles() {

	wp_enqueue_style( 'tish1-stylesheet', get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'tish4-child-style', get_stylesheet_uri(), array( 'tish4-stylesheet' ) );
}
add_action( 'wp_enqueue_scripts', 'tish4_enqueue_styles' );


if ( ! class_exists( 'tish4_Customize' ) ) :
	/**
	 * Singleton class for handling the theme's customizer integration.
	 */
	final class tish4_Customize {

		// Returns the instance.
		public static function get_instance() {

			static $instance = null;

			if ( is_null( $instance ) ) {
				$instance = new self;
				$instance->setup_actions();
			}

			return $instance;
		}

		// Constructor method.
		private function __construct() {}

		// Sets up initial actions.
		private function setup_actions() {

			// Register panels, sections, settings, controls, and partials.
			add_action( 'customize_register', array( $this, 'sections' ) );

			// Register scripts and styles for the controls.
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
		}

		// Sets up the customizer sections.
		public function sections( $manager ) {

			// Load custom sections.

			// Register custom section types.
			$manager->register_section_type( 'tish1_Customize_Section_Pro' );

			// Register sections.
			$manager->add_section(
				new tish1_Customize_Section_Pro(
					$manager,
					'tish4',
					array(
						'title'    => esc_html__( 'tCommerce', 'tish4' ),
						'pro_text' => esc_html__( 'Upgrade', 'tish4' ),
						'pro_url'  => esc_url( 'https://tishonator.com/product/tcommerce' )
					)
				)
			);
		}

		// Loads theme customizer CSS.
		public function enqueue_control_scripts() {

			wp_enqueue_script( 'tish1-customize-controls', trailingslashit( get_template_directory_uri() ) . 'js/customize-controls.js', array( 'customize-controls' ) );

			wp_enqueue_style( 'tish1-customize-controls', trailingslashit( get_template_directory_uri() ) . 'css/customize-controls.css' );
		}
	}
endif; // tish4_Customize

// Doing this customizer thang!
tish4_Customize::get_instance();

/**
 * Remove Parent theme Customize Up-Selling Section
 */
if ( ! function_exists( 'tish4_remove_parent_theme_upsell_section' ) ) :

	function tish4_remove_parent_theme_upsell_section( $wp_customize ) {

		// Remove Parent-Theme Upsell section
		$wp_customize->remove_section('tish1');
	}

endif; // tish4_remove_parent_theme_upsell_section

add_action( 'customize_register', 'tish4_remove_parent_theme_upsell_section', 100 );
