<?php
/**
 * Theme functions and definitions
 *
 * @package the_gig
 */ 


if ( ! function_exists( 'the_gig_enqueue_styles' ) ) :
	/**
	 * Load assets.
	 *
	 * @since 1.0.0
	 */
	function the_gig_enqueue_styles() {
		wp_enqueue_style( 'the-event-style-parent', get_template_directory_uri() . '/style.css' );
		wp_enqueue_style( 'the-gig-style', get_stylesheet_directory_uri() . '/style.css', array( 'the-event-style-parent' ), '1.0.0' );

		// Add custom fonts, used in the main stylesheet.
        wp_enqueue_style( 'the-gig-fonts', the_gig_fonts_url(), array(), null );
	}
endif;
add_action( 'wp_enqueue_scripts', 'the_gig_enqueue_styles', 99 );

function the_gig_do_action() {
	add_action( 'customize_register', 'the_gig_customize_register' );
    remove_action( 'the_event_header_start_action', 'the_gig_header_start', 10 );
}
add_action( 'init', 'the_gig_do_action');

function the_gig_customize_register( $wp_customize ) {
	$wp_customize->remove_control('the_event_theme_options[header_layout]');
	$wp_customize->add_control( 'the_event_theme_options[header_layout]', array(
		'label'             => esc_html__( 'Header Layout', 'the-gig' ),
		'section'           => 'the_event_header_section',
		'type'				=> 'radio',
		'choices'			=> array( 
			'normal-header' 	=> esc_html__( 'Normal', 'the-gig' ),
			'absolute-header' 	=> esc_html__( 'Absolute', 'the-gig' ),
			'center-header' 	=> esc_html__( 'Center Align', 'the-gig' ),
		),
	) );
}

if ( ! function_exists( 'the_gig_theme_defaults' ) ) :
    /**
     * Customize theme defaults.
     *
     * @since 1.0.0
     *
     * @param array $defaults Theme defaults.
     * @param array Custom theme defaults.
     */
    function the_gig_theme_defaults( $defaults ) {
        $defaults['header_layout'] = 'absolute-header';
        $defaults['enable_slider'] = false;
        $defaults['enable_slider_wave'] = true;
        $defaults['slider_align'] = 'center-align';
        $defaults['enable_hero_content'] = false;
        $defaults['enable_speaker'] = false;
        $defaults['enable_service'] = false;
        $defaults['enable_team'] = false;
        $defaults['enable_schedule'] = false;
        $defaults['enable_gallery'] = false;
        $defaults['enable_portfolio'] = false;
        $defaults['enable_skills'] = false;
        $defaults['enable_product'] = false;
        $defaults['enable_client'] = false;
        $defaults['enable_testimonial'] = false;
        $defaults['enable_recent'] = false;
        $defaults['enable_cta'] = false;
        $defaults['enable_contact'] = false;

        return $defaults;
    }
endif;
add_filter( 'the_event_default_theme_options', 'the_gig_theme_defaults', 99 );

/**
 * Enqueue editor styles for Gutenberg
 */
function the_gig_block_editor_styles() {
    // Add custom fonts.
    wp_enqueue_style( 'the-gig-fonts', the_gig_fonts_url(), array(), null );
}
add_action( 'enqueue_block_editor_assets', 'the_gig_block_editor_styles' );

if ( ! function_exists( 'the_gig_fonts_url' ) ) :
/**
 * Register Google fonts
 *
 * @return string Google fonts URL for the theme.
 */
function the_gig_fonts_url() {
    $fonts_url = '';
    $fonts     = array();
    $subsets   = 'latin,latin-ext';

    /* translators: If there are characters in your language that are not supported by Poppins, translate this to 'off'. Do not translate into your own language. */
    if ( 'off' !== _x( 'on', 'Poppins font: on or off', 'the-gig' ) ) {
        $fonts[] = 'Poppins:300,400,500,600,700';
    }

    $query_args = array(
        'family' => urlencode( implode( '|', $fonts ) ),
        'subset' => urlencode( $subsets ),
    );

    if ( $fonts ) {
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    return esc_url_raw( $fonts_url );
}
endif;

// Add class to body.
add_filter( 'body_class', 'the_gig_add_body_class' );
function the_gig_add_body_class( $classes ) {
    return array_merge( $classes, array( 'header-font-11', 'body-font-8' ) );
}

if ( ! function_exists( 'the_gig_header_start' ) ) :
	/**
	 * Header starts html codes
	 *
	 * @since The Event 1.0.0
	 */
	function the_gig_header_start() { 
		$header_layout = the_event_theme_option( 'header_layout', 'normal-header' ); 
		?>
		<header id="masthead" class="site-header <?php echo esc_attr( $header_layout ); ?>">
		<div class="wrapper">
	<?php }
endif;
add_action( 'the_event_header_start_action', 'the_gig_header_start', 10 );

if ( ! function_exists( 'the_event_render_slider_section' ) ) :
  /**
   * Start slider section
   *
   * @return string slider content
   * @since The Event 1.0.0
   *
   */
   function the_event_render_slider_section( $content_details = array() ) {
        if ( empty( $content_details ) )
            return;

        $slider_control = the_event_theme_option( 'slider_arrow' );
        $slider_autoplay = the_event_theme_option( 'slider_autoplay' );
        $slider_btn_label = the_event_theme_option( 'slider_btn_label', '' );
        $slider_alt_btn_link = the_event_theme_option( 'slider_alt_btn_link', '' );
        $slider_alt_btn_label = the_event_theme_option( 'slider_alt_btn_label', '' );
        $slider_opacity = the_event_theme_option( 'slider_opacity', 0 );
        $slider_align = the_event_theme_option( 'slider_align', 'center-align' );
        $slider_text = the_event_theme_option( 'slider_text', 'light-text' );
        $slider_alt_btn_color = the_event_theme_option( 'slider_alt_btn_color' );
        ?>
        <div id="custom-header">
            <div class="section-content banner-slider <?php echo esc_attr( $slider_align ); ?> <?php echo esc_attr( $slider_text ); ?>" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "infinite": true, "speed": 1200, "dots": false, "arrows":<?php echo $slider_control ? 'true' : 'false'; ?>, "autoplay": <?php echo $slider_autoplay ? 'true' : 'false'; ?>, "fade": true, "draggable": true }'>
                <?php foreach ( $content_details as $content ) : ?>
                    <div class="custom-header-content-wrapper slide-item">
                        <?php if ( ! empty( $content['image'] ) ) : ?>
                            <img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>">
                        <?php endif; ?>
                        <div class="overlay" style="opacity: 0.<?php echo absint( $slider_opacity ); ?>"></div>
                        <div class="wrapper">
                            <div class="custom-header-content">
                                 <?php if ( ! empty( $content['sub_title'] ) ) : ?>
                                    <p class="sub-title"><?php echo esc_html( $content['sub_title'] ); ?></p>
                                <?php endif; 

                                if ( ! empty( $content['title'] ) ) : ?>
                                    <h2><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                <?php endif; 

                                if ( ! empty( $content['excerpt'] ) ) : ?>
                                    <p><?php echo wp_kses_post( $content['excerpt'] ); ?></p>
                                <?php endif;

                                if ( ! empty( $slider_btn_label ) ) : ?>
                                    <div class="read-more">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $slider_btn_label ); ?></a>
                                    </div>
                                <?php endif;

                                if ( ! empty( $slider_alt_btn_label ) && ! empty( $slider_alt_btn_link ) ) : ?>
                                    <div class="read-more alt-btn <?php echo $slider_alt_btn_color ? 'alt-btn-primary' : ''; ?>">
                                        <a href="<?php echo esc_url( $slider_alt_btn_link ); ?>"><?php echo esc_html( $slider_alt_btn_label ); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div><!-- .custom-header-content -->
                        </div>
                    </div><!-- .custom-header-content-wrapper -->
                <?php endforeach; ?>
            </div><!-- .wrapper -->

            <?php if ( the_event_theme_option( 'enable_slider_wave', false ) ) : ?>
                <div class="wave-saperator">
                    <?php 
                        $wave = 'dark' == the_event_theme_option( 'theme_color_mode', 'light' ) ? 'dark-wave-2' : 'wave-3';
                        echo the_event_get_svg( array( 'icon' => 'wave-3' ) ); 
                    ?>
                </div>
            <?php endif; ?>
        </div><!-- #custom-header -->
    <?php 
    }
endif;