<?php

/**
 * The default template for displaying Header
 *
 * @package TechBeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

$techbeeps_header_layout = get_theme_mod('techbeeps_header_layout', 'container');
$sticky   = get_theme_mod('techbeeps_header_sticky') ? 'sticky' : '';
$transparent = get_theme_mod('techbeeps_header_transparent') ? 'transparent' : '';
?>
<header id="masthead" class="site-header <?php echo esc_attr($sticky) ?> <?php echo esc_attr($transparent) ?>">
    <div class="techbeeps-header techbeeps-<?php echo esc_attr($techbeeps_header_layout); ?>">
        <div class="techbeeps-logo site-branding">
            <?php
            // Logo or site title
            if (has_custom_logo()) {
                the_custom_logo();
            } else {
                printf(
                    '<span class="site-title"><a href="%s" rel="home">%s</a></span>',
                    esc_url(home_url('/')),
                    esc_html(get_bloginfo('name'))
                );
            }
            ?>
        </div><!-- .site-branding -->

        <nav id="site-navigation" class="main-navigation techbeeps-navigation">

            <?php
            // Primary menu
            wp_nav_menu([
                'theme_location' => 'primary',
                'menu_id'        => 'primary-menu',
                'container'      => false,
            ]);
            ?>
        </nav><!-- #site-navigation -->
        <!-- Mobile Menu Toggle Button -->
        <button id="techbeeps-mobile-menu-toggle" class="techbeeps-menu-toggle techbeeps-mobile-menu-toggle" aria-controls="mobile-menu" aria-label="Open mobile menu" aria-expanded="false">☰</button>
        <?php dynamic_sidebar('header-after-nav'); ?>
    </div><!-- .container -->
    <div id="techbeeps-mobile-menu-canvas" class="techbeeps-mobile-menu-canvas" inert>
        <button class="techbeeps-mobile-menu-close" aria-label="Close mobile menu">×</button>
        <?php
        wp_nav_menu([
            'theme_location' => 'mobile',
            'menu_id'        => 'mobile-menu',
            'container'      => false,
        ]);
        ?>
    </div>
    <div id="techbeeps-canvas-backdrop" class="techbeeps-canvas-backdrop"></div>
</header><!-- #masthead -->