<?php

/**
 * The default template for displaying Footer
 *
 * @package TechBeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
?>

<footer id="colophon" class="site-footer techbeeps-footer">
    <?php
    // Check if Elementor footer exists (Theme Builder)
    if (function_exists('elementor_theme_do_location')) {
        elementor_theme_do_location('footer');
    }
    // Fallback: Default theme footer
    else {
    ?>
        <div class="techbeeps-container">
            <?php
            $layout = get_theme_mod('techbeeps_footer_column_layout', '33-33-33');
            $columns = explode('-', $layout);
            ?>
            <div class="footer-widgets">
                <?php foreach ($columns as $index => $width) : ?>
                    <div class="footer-col" style="width: <?php echo esc_attr($width) ?>%;">
                        <?php dynamic_sidebar('footer-' . ($index + 1)); ?>
                    </div>
                <?php endforeach; ?>
            </div>

        </div><!-- .container -->
        <div class="site-info techbeeps-site-info">
            <?php
            $raw_text = get_theme_mod('techbeeps_footer_copyright_text', 'Copyright © [year] [site_title]. All rights reserved.');
            $replaced_text = str_replace(['[year]', '[site_title]'], [date('Y'), esc_html(get_bloginfo('name'))], $raw_text);
            echo wp_kses_post(wpautop($replaced_text));
            ?>

        </div><!-- .site-info -->
    <?php
    }
    ?>
</footer><!-- #colophon -->