<?php

/**
 * The default template for displaying content single posts.
 *
 * @package TechBeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="entry-header">
        <?php if (has_post_thumbnail()) : ?>
            <div class="post-thumbnail">
                <a href="<?php echo esc_url(the_permalink()); ?>" aria-label="<?php the_title_attribute(); ?>">
                    <?php the_post_thumbnail('large', ['class' => 'img-fluid']); ?>
                </a>
            </div>
        <?php endif;

        if (is_singular()) :

            the_title('<h1 class="entry-title">', '</h1>');
        else :
            the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
        endif;
        // Replace the undefined function with standard WordPress function
        ?>
    </header><!-- .entry-header -->

    <div class="entry-content">
        <?php

        the_content(
            sprintf(
                wp_kses(
                    __('Continue reading %s <span class="meta-nav">&rarr;</span>', 'techbeeps'),
                    ['span' => ['class' => []]]
                ),
                '<span class="screen-reader-text">' . get_the_title() . '</span>'
            )
        );



        wp_link_pages([
            'before' => '<div class="page-links">' . esc_html__('Pages:', 'techbeeps'),
            'after'  => '</div>',
        ]);

        ?>
    </div><!-- .entry-content -->
    <?php
    // Add tags section between content and footer
    if (get_the_tag_list()) : ?>
        <div class="techbeeps-entry-tags">
            <?php the_tags('<span class="techbeeps-tags-label">' . __('Tagged:', 'techbeeps') . '</span> ', ' ', ''); ?>
        </div>
    <?php endif; ?>

    
    <footer class="entry-footer">
        <?php edit_post_link(__('Edit', 'techbeeps'), '<span class="edit-link">', '</span>'); ?>
    </footer>
</article><!-- #post-<?php the_ID(); ?> -->