<?php

/**
 * Template part for displaying a message that posts cannot be found
 *
 * @package techbeeps
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

?>
<section class="no-results not-found">
    <header class="page-header">
        <h1 class="page-title"><?php esc_html_e('Nothing Found', 'techbeeps'); ?></h1>
    </header><!-- .page-header -->

    <div class="page-content">
        <?php
        if (is_home() && current_user_can('publish_posts')) :
            printf(
                '<p>%s</p>',
                wp_kses(
                    sprintf(
                        /* translators: %s: Link to create a new post */
                        __('Ready to publish your first post? <a href="%s">Get started here</a>.', 'techbeeps'),
                        esc_url(admin_url('post-new.php'))
                    ),
                    ['a' => ['href' => []]]
                )
            );
        elseif (is_search()) :
        ?>
            <p><?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'techbeeps'); ?></p>
        <?php
            get_search_form();
        else :
        ?>
            <p><?php esc_html_e("It seems we can't find what yo're looking for. Perhaps searching can help.", 'techbeeps'); ?></p>
        <?php
            get_search_form();
        endif;
        ?>
    </div><!-- .page-content -->
</section><!-- .no-results -->