<?php

/**
 * The template for displaying all single posts
 *
 * @package techbeeps
 */

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

get_header();

$sidebar_layout = get_post_meta(get_the_ID(), '_techbeeps_sidebar_layout', true) ?: 'default';

?>
<div id="content" class="site-content">
    <div class="techbeeps-wrapper <?php echo esc_attr(techbeeps_get_layout_classes()); ?>">
        <?php
        if ($sidebar_layout === 'sidebar-left') {
            get_sidebar();
        } ?>
        <div id="primary" class="content-area primary">
            <main id="main" class="site-main single">
                <?php
                while (have_posts()) :
                    the_post();

                    get_template_part('template-parts/content', 'single');
                    // Previous/next post navigation
                    the_post_navigation(
                        array(
                            'prev_text' => '<span class="nav-subtitle">' . esc_html__('Previous:', 'techbeeps') . '</span> <span class="nav-title">%title</span>',
                            'next_text' => '<span class="nav-subtitle">' . esc_html__('Next:', 'techbeeps') . '</span> <span class="nav-title">%title</span>',
                        )
                    );
                    // If comments are open or we have at least one comment, load up the comment template
                    if (comments_open() || get_comments_number()) :
                        comments_template();
                    endif;

                endwhile; // End of the loop.
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->
        <?php
        if ($sidebar_layout === 'sidebar-right') {
            get_sidebar();
        } ?>
    </div> <!-- techbeeps-wrapper -->
</div><!--content-->
<?php get_footer(); ?>