<?php

/**
 * The template for displaying search results
 *
 * @package techbeeps
 */

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

get_header();

$sidebar_layout = get_post_meta(get_the_ID(), '_techbeeps_sidebar_layout', true) ?: 'default';
?>
<div id="content" class="site-content">
    <div class="techbeeps-wrapper <?php echo esc_attr(techbeeps_get_layout_classes()); ?>">
        <?php
        if ($sidebar_layout === 'sidebar-left') {
            get_sidebar();
        } ?>
        <div id="primary" class="content-area primary">
            <main id="main" class="site-main search">
                <?php

                if (have_posts()) : ?>
                    <header class="page-header">
                        <h1 class="page-title">
                            <?php
                            /* translators: %s: search query. */
                            printf(esc_html__('Search Results for: %s', 'techbeeps'),  '<span>' . esc_html(get_search_query()) . '</span>');
                            ?>
                        </h1>
                    </header><!-- .page-header -->

                <?php
                    /* Start the Loop */
                    while (have_posts()) :
                        the_post();
                        /**
                         * Run the loop for the search to output the results.
                         * If you want to overload this in a child theme then include a file
                         * called content-search.php and that will be used instead.
                         */
                        get_template_part('template-parts/content', 'post');

                    endwhile;

                    the_posts_navigation();

                else :

                    get_template_part('template-parts/content', 'none');

                endif;
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->
        <?php
        // If the sidebar layout is 'sidebar-right', include the sidebar
        if ($sidebar_layout === 'sidebar-right') {
            get_sidebar();
        } ?>
    </div> <!-- techbeeps-wrapper -->
</div><!--content-->
<?php get_footer(); ?>