<?php

/**
 * The template for displaying all pages
 *
 * @package techbeeps
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
get_header();

$sidebar_layout = get_post_meta(get_the_ID(), '_techbeeps_sidebar_layout', true) ?: 'default';
$techbeeps_global_sidebar_layout = get_theme_mod('techbeeps_global_sidebar_layout', 'no sidebar');
$sidebar_layout = $sidebar_layout == 'default' ? $techbeeps_global_sidebar_layout : $sidebar_layout;

if (class_exists('WooCommerce') && (is_cart() or  is_checkout() or  is_account_page())) {
    $sidebar_layout = 'no sidebar';
}


?>
<div id="content" class="site-content">
    <div class="techbeeps-wrapper <?php echo esc_attr(techbeeps_get_layout_classes()); ?>">
        <?php
        if ($sidebar_layout === 'sidebar-left') {
            get_sidebar();
        } ?>
        <div id="primary" class="content-area primary">
            <main id="main" class="site-main page">
                <?php
                while (have_posts()) :
                    the_post();
                    get_template_part('template-parts/content', 'page');
                    // If comments are open or we have at least one comment, load up the comment template
                    if (comments_open() || get_comments_number()) :
                        comments_template();
                    endif;

                endwhile; // End of the loop.
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->
        <?php
        if ($sidebar_layout === 'sidebar-right') {
            get_sidebar();
        } ?>
    </div> <!-- techbeeps-wrapper -->
</div><!--content-->
<?php get_footer(); ?>