<?php

/**
 * The main template file
 *
 * @package techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
get_header();

$sidebar_layout = get_post_meta(get_the_ID(), '_techbeeps_sidebar_layout', true) ?: 'default';
?>
<div id="content" class="site-content">
    <div class="techbeeps-wrapper <?php echo esc_attr(techbeeps_get_layout_classes()); ?>">
        <?php
        if ($sidebar_layout === 'sidebar-left') {
            get_sidebar();
        } ?>
        <div id="primary" class="content-area primary">
            <main id="main" class="site-main index">
                <?php
                if (have_posts()) :
                    if (is_home() && !is_front_page()) :
                ?>
                        <header>
                            <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
                        </header>
                <?php
                    endif;

                    // Start the Loop
                    while (have_posts()) :
                        the_post();
                        get_template_part('template-parts/content', get_post_type());
                    endwhile;

                    the_posts_pagination(array(
                        'mid_size'  => 2,
                        'prev_text' =>'<',
                        'next_text' => '>',
                    ) );
                else :
                    get_template_part('template-parts/content', 'none');
                endif;
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->

        <?php
        if ($sidebar_layout === 'sidebar-right') {
            get_sidebar();
        } ?>
    </div> <!-- techbeeps-wrapper -->
</div><!--content-->
<?php get_footer(); ?>