<?php
/**
 * Dynamic styles for the theme
 *
 * @package techbeeps
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

function techbeeps_enqueue_dynamic_styles_data()
{

    $primary_color       = esc_attr(get_theme_mod('techbeeps_primary_color', '#343fcd'));
    $secondary_color     = esc_attr(get_theme_mod('techbeeps_secondary_color', '#00c850'));
    $primary_bg_color    = esc_attr(get_theme_mod('techbeeps_primary_bg_color', '#f4f4f4'));
    $secondary_bg_color  = esc_attr(get_theme_mod('techbeeps_secondary_bg_color', '#ffffff'));
    $heading_color       = esc_attr(get_theme_mod('techbeeps_heading_color', '#222222'));
    $text_color          = esc_attr(get_theme_mod('techbeeps_text_color', '#555555'));
    $link_color          = esc_attr(get_theme_mod('techbeeps_link_color', '#4c4c4c'));
    $bg_color_footer     = esc_attr(get_theme_mod('techbeeps_footer_bg_color', '#fff'));
    $text_color_footer   = esc_attr(get_theme_mod('techbeeps_footer_text_color', '#555555'));

    if ($text_color_footer === '') {
        $text_color_footer = $text_color;
    }

    $techbeeps_logo_width = absint(get_theme_mod('techbeeps_logo_width', 100));
    $container_width = absint(get_theme_mod('techbeeps-container-width', 1200));
    $narrow_width = absint(get_theme_mod('techbeeps-narrow-container-width', 750));
    $margin = json_decode(get_theme_mod('techbeeps_footer_margin_box_model'), true);
    $margin = is_array($margin) ? $margin : ['top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0];
    $margin_top    = absint($margin['top']);
    $margin_right  = absint($margin['right']);
    $margin_bottom = absint($margin['bottom']);
    $margin_left   = absint($margin['left']);
    $padding = json_decode(get_theme_mod('techbeeps_footer_padding_box_model'), true);
    $padding = is_array($padding) ? $padding : ['top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0];
    $padding_top    = absint($padding['top']);
    $padding_right  = absint($padding['right']);
    $padding_bottom = absint($padding['bottom']);
    $padding_left   = absint($padding['left']);
    $techbeeps_header_padding = json_decode(get_theme_mod('techbeeps_header_padding'), true);
    $techbeeps_header_padding = is_array($techbeeps_header_padding) ? $techbeeps_header_padding : ['top' => 0, 'right' => 0, 'bottom' => 0, 'left' => 0];
    $techbeeps_header_padding_top    = absint($techbeeps_header_padding['top']);
    $techbeeps_header_padding_right  = absint($techbeeps_header_padding['right']);
    $techbeeps_header_padding_bottom = absint($techbeeps_header_padding['bottom']);
    $techbeeps_header_padding_left   = absint($techbeeps_header_padding['left']);
    $bg_header_color = esc_attr(get_theme_mod('techbeeps_header_bg_color', '#fff'));

    //typography
    $techbeeps_typography_json = get_theme_mod('techbeeps_typography', '[]');
    $techbeeps_typography = json_decode($techbeeps_typography_json, true);
    $techbeeps_typography = is_array($techbeeps_typography) ? $techbeeps_typography : [];
    //body values
    $font_family = esc_attr($techbeeps_typography['body']['font_family'] ?? 'Arial, sans-serif');
    $font_weight = esc_attr($techbeeps_typography['body']['font_weight'] ?? '400');
    $text_transform = esc_attr($techbeeps_typography['body']['text_transform'] ?? 'none');
    $font_size = esc_attr($techbeeps_typography['body']['font_size'] ?? 16);
    $line_height = esc_attr($techbeeps_typography['body']['line_height'] ?? 1.6);
    $word_spacing = esc_attr($techbeeps_typography['body']['word_spacing'] ?? 0);
    $font_styles = esc_attr($techbeeps_typography['body']['font_style'] ?? 'normal');
    $text_decoration = esc_attr($techbeeps_typography['body']['text_decoration'] ?? 'none');
    $paragraph_m_bottom = esc_attr($techbeeps_typography['body']['paragraph_m_bottom'] ?? 0.5);
    // Heading values
    $h_font_family = esc_attr($techbeeps_typography['heading']['font_family'] ?? 'Arial, sans-serif');
    $h_font_weight = esc_attr($techbeeps_typography['heading']['font_weight'] ?? '600');
    $h_text_transform = esc_attr($techbeeps_typography['heading']['text_transform'] ?? 'none');
    $h_line_height = esc_attr($techbeeps_typography['heading']['line_height'] ?? 1.6);
    $h_word_spacing = esc_attr($techbeeps_typography['heading']['word_spacing'] ?? 0);
    $h_font_styles = esc_attr($techbeeps_typography['heading']['font_style'] ?? 'normal');
    $h_text_decoration = esc_attr($techbeeps_typography['heading']['text_decoration'] ?? 'none');
    $h1_font_size = esc_attr($techbeeps_typography['heading']['heading_1_fs'] ?? 48);
    $h2_font_size = esc_attr($techbeeps_typography['heading']['heading_2_fs'] ?? 36);
    $h3_font_size = esc_attr($techbeeps_typography['heading']['heading_3_fs'] ?? 30);
    $h4_font_size = esc_attr($techbeeps_typography['heading']['heading_4_fs'] ?? 28);
    $h5_font_size = esc_attr($techbeeps_typography['heading']['heading_5_fs'] ?? 26);
    $h6_font_size = esc_attr($techbeeps_typography['heading']['heading_6_fs'] ?? 18);

    // button values
    $techbeeps_btn_txt_color = esc_attr(get_theme_mod('techbeeps_btn_txt_color', '#ffffff'));
    $techbeeps_btn_hover_txt_color = esc_attr(get_theme_mod('techbeeps_btn_hover_txt_color', '#ffffff'));
    $techbeeps_btn_bg_color = esc_attr(get_theme_mod('techbeeps_btn_bg_color', '#343fcd'));
    $techbeeps_btn_hover_bg_color = esc_attr(get_theme_mod('techbeeps_btn_hover_bg_color', '#00c850'));
    $techbeeps_btn_border_color = esc_attr(get_theme_mod('techbeeps_btn_border_color', '#00c850'));
    $techbeeps_btn_hover_border_color = esc_attr(get_theme_mod('techbeeps_btn_hover_border_color', '#343fcd'));
    $techbeeps_btn_padding = esc_attr(get_theme_mod('techbeeps_btn_padding', '10px 20px'));
    $techbeeps_btn_radius = esc_attr(get_theme_mod('techbeeps_btn_radius', '5px'));
    $techbeeps_btn_border_width = esc_attr(get_theme_mod('techbeeps_btn_border_width', '1px'));
    $techbeeps_btn_font_size = esc_attr(get_theme_mod('techbeeps_btn_font_size', '16'));

    //sidebar values
    $techbeeps_sidebar_width = esc_attr(get_theme_mod('techbeeps_sidebar_width', '25'));
    $css = "

:root {
    --techbeeps-primary-color: {$primary_color}; 
    --techbeeps-secondary-color: {$secondary_color};
    --techbeeps-primary-bg-color: {$primary_bg_color};
    --techbeeps-secondary-bg-color: {$secondary_bg_color};
    --techbeeps-heading-color: {$heading_color};
    --techbeeps-text-color: {$text_color};
    --techbeeps-link-color: {$link_color};
    --techbeeps-font-family: {$font_family};
    --techbeeps-font-weight: {$font_weight};
    --techbeeps-font-size: {$font_size}px;
    --techbeeps-line-height: {$line_height};
    --techbeeps-word-spacing: {$word_spacing}px; 
    --techbeeps-text-transform: {$text_transform};
    --techbeeps-font-style: {$font_styles};
    --techbeeps-text-decoration: {$text_decoration}; 
    --techbeeps-paragraph-m-bottom: {$paragraph_m_bottom}em;
    --techbeeps-h-font-family: {$h_font_family};
    --techbeeps-h-font-weight: {$h_font_weight};
    --techbeeps-h-text-transform: {$h_text_transform};
    --techbeeps-h-line-height: {$h_line_height};
    --techbeeps-h-word-spacing: {$h_word_spacing}px;
    --techbeeps-h-font-style: {$h_font_styles};
    --techbeeps-h-text-decoration: {$h_text_decoration};
    --techbeeps-h1-font-size: {$h1_font_size}px;
    --techbeeps-h2-font-size: {$h2_font_size}px;
    --techbeeps-h3-font-size: {$h3_font_size}px;
    --techbeeps-h4-font-size: {$h4_font_size}px;
    --techbeeps-h5-font-size: {$h5_font_size}px;
    --techbeeps-h6-font-size: {$h6_font_size}px;
    --techbeeps-logo-width: {$techbeeps_logo_width}px;
    --techbeeps-footer-bg-color:{$bg_color_footer};
    --techbeeps-footer-color:{$text_color_footer};
    --techbeeps-wrapper-container-width: {$container_width}px;
    --techbeeps-wrapper-narrow-width: {$narrow_width}px;
    --techbeeps-footer-margin: {$margin_top}px {$margin_right}px {$margin_bottom}px {$margin_left}px;
    --techbeeps-footer-padding:{$padding_top}px {$padding_right}px {$padding_bottom}px {$padding_left}px;
    --techbeeps-header-bg-color: {$bg_header_color} ; 
    --techbeeps-header-padding:{$techbeeps_header_padding_top}px {$techbeeps_header_padding_right}px {$techbeeps_header_padding_bottom}px {$techbeeps_header_padding_left}px;
    --techbeeps-btn-txt-color: {$techbeeps_btn_txt_color};
    --techbeeps-btn-hover-txt-color: {$techbeeps_btn_hover_txt_color};
    --techbeeps-btn-bg-color: {$techbeeps_btn_bg_color};
    --techbeeps-btn-hover-bg-color: {$techbeeps_btn_hover_bg_color};
    --techbeeps-btn-border-color: {$techbeeps_btn_border_color};
    --techbeeps-btn-hover-border-color: {$techbeeps_btn_hover_border_color};
    --techbeeps-btn-padding: {$techbeeps_btn_padding};
    --techbeeps-btn-radius: {$techbeeps_btn_radius};
    --techbeeps-btn-border-width: {$techbeeps_btn_border_width};
    --techbeeps-btn-font-size: {$techbeeps_btn_font_size}px;
    --techbeeps-sidebar-width: {$techbeeps_sidebar_width}%;
  ";
    return $css;
}

function techbeeps_enqueue_dynamic_styles()
{
    //enqueue_google_font
    techbeeps_enqueue_google_font();
    //enqueue_dynamic_styles
    wp_register_style('techbeeps-dynamic', false);
    wp_enqueue_style('techbeeps-dynamic');
    $css_data = wp_strip_all_tags(techbeeps_enqueue_dynamic_styles_data());
    wp_add_inline_style('techbeeps-dynamic', $css_data);
}
add_action('wp_enqueue_scripts', 'techbeeps_enqueue_dynamic_styles', 20);
