<?php
/**
 * techbeeps customizer controls
 *
 * @package techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// logo customize
function techbeeps_logo_customize_register($wp_customize)
{
    require_once TECHBEEPS_DIR . '/inc/custom-controls/class-customizer-logo-size-control.php';

    $wp_customize->add_setting('techbeeps_logo_width', array(
        'default'           => 100,
        'sanitize_callback' => 'absint',
        'transport'         => 'postMessage', // Enable live preview
    ));
    // Add custom control below
    $wp_customize->add_control(new Techbeeps_Customizer_logo_size_Control($wp_customize, 'techbeeps_logo_width', array(
        'label'       => __('Logo Width', 'techbeeps'),
        'section'     => 'title_tagline',
        'input_attrs' => array(
            'min'  => 50,
            'max'  => 400,
            'step' => 1,
        ),
    )));
}
add_action('customize_register', 'techbeeps_logo_customize_register');
// footer customize options
function techbeeps_footer_customize_register($wp_customize)
{

    require TECHBEEPS_DIR . '/inc/custom-controls/class-footer-layout-control.php';

    $wp_customize->add_section('footer_layout_section', [
        'title'    => __('Footer', 'techbeeps'),
        'priority' => 130,
    ]);

    $wp_customize->add_setting('techbeeps_footer_column_layout', [
        'default'   => '33-33-33',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field'
,
    ]);

    $wp_customize->add_control(new Techbeeps_Footer_Layout_Control($wp_customize, 'techbeeps_footer_column_layout', [
        'label'    => __('Select Footer Layout', 'techbeeps'),
        'section'  => 'footer_layout_section',
        'settings' => 'techbeeps_footer_column_layout',
        'choices'  => [
            '33-33-33'     => __('Equal (3 Columns)', 'techbeeps'),
            '50-25-25'     => __('Wide Left', 'techbeeps'),
            '25-50-25'     => __('Wide Middle', 'techbeeps'),
            '25-25-50'     => __('Wide Right', 'techbeeps'),
            '25-25-25-25'  => __('4 Columns', 'techbeeps'),
        ],
    ]));
    $wp_customize->add_setting('techbeeps_footer_bg_color', [
        'default'           => '#fff',
        'sanitize_callback' => 'sanitize_hex_color',
    ]);

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_footer_bg_color', [
        'label'   => __('Footer Background Color', 'techbeeps'),
        'section' => 'footer_layout_section',
        'settings' => 'techbeeps_footer_bg_color',
    ]));

    // Text Color
    $wp_customize->add_setting('techbeeps_footer_text_color', [
        'default'           => '#555555',
        'sanitize_callback' => 'sanitize_hex_color',
    ]);

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_footer_text_color', [
        'label'   => __('Footer Text Color', 'techbeeps'),
        'section' => 'footer_layout_section',
        'settings' => 'techbeeps_footer_text_color',
    ]));

    $wp_customize->add_setting('techbeeps_footer_copyright_text', [
        'default'           => 'Copyright © [year] [site_title]. All rights reserved.',
        'sanitize_callback' => 'sanitize_text_field',
    ]);

    $wp_customize->add_control('techbeeps_footer_copyright_text', [
        'label'   => __('Copyright Text', 'techbeeps'),
        'section' => 'footer_layout_section',
        'type'    => 'textarea',
    ]);

    // Margin setting
    $wp_customize->add_setting('techbeeps_footer_margin_box_model', [
        'default' => wp_json_encode(['top' => '0', 'right' => '0', 'bottom' => '0', 'left' => '0']),
        'transport' => 'refresh',
        'sanitize_callback' => function ($value) {
            $decoded = json_decode($value, true);
            return wp_json_encode(array_map('sanitize_text_field', $decoded));
        },
    ]);

    $wp_customize->add_control(new Techbeeps_Footer_BoxModel_Control($wp_customize, 'techbeeps_footer_margin_box_model', [
        'label' => __('Margin (Top, Right, Bottom, Left)', 'techbeeps'),
        'section' => 'footer_layout_section',
    ]));

    // Padding setting
    $wp_customize->add_setting('techbeeps_footer_padding_box_model', [
        'default' => wp_json_encode(['top' => '40', 'right' => '0', 'bottom' => '20', 'left' => '0']),
        'transport' => 'refresh',
        'sanitize_callback' => function ($value) {
            $decoded = json_decode($value, true);
            return wp_json_encode(array_map('sanitize_text_field', $decoded));
        },
    ]);

    $wp_customize->add_control(new Techbeeps_Footer_BoxModel_Control($wp_customize, 'techbeeps_footer_padding_box_model', [
        'label' => __('Padding (Top, Right, Bottom, Left)', 'techbeeps'),
        'section' => 'footer_layout_section',
    ]));
}
add_action('customize_register', 'techbeeps_footer_customize_register');
// header customize options
function techbeeps_header_customize_register($wp_customize)
{

    require TECHBEEPS_DIR . '/inc/custom-controls/class-header-layout-control.php';

    $wp_customize->add_section('header_custom_options', [
        'title'    => __('Header', 'techbeeps'),
        'priority' => 120,
    ]);

    $wp_customize->add_setting('techbeeps_header_layout', [
        'default' => 'container',
        'sanitize_callback' => function ($input) {
            return in_array($input, ['container', 'fullwidth', 'narrow']) ? $input : 'container';
        }
    ]);

    // Add custom control
    $wp_customize->add_control(new Techbeeps_Layout_Radio_Image_Control(
        $wp_customize,
        'techbeeps_header_layout',
        [
            'label' => __('Choose Header Layout', 'techbeeps'),
            'section' => 'header_custom_options',
            'choices' => [
                'container' => __('Container', 'techbeeps'),
                'fullwidth' => __('Full Width', 'techbeeps'),
                'narrow' => __('Narrow', 'techbeeps'),
            ],
        ]
    ));
    // Background Color
    $wp_customize->add_setting('techbeeps_header_bg_color', [
        'default'           => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ]);
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_header_bg_color', [
        'label'   => __('Header Background Color', 'techbeeps'),
        'section' => 'header_custom_options',
    ]));

    // Sticky Header Setting
    $wp_customize->add_setting('techbeeps_header_sticky', [
        'default' => false,
        'sanitize_callback' => 'wp_validate_boolean',
    ]);
    $wp_customize->add_control(new Techbeeps_Toggle_Switch_Custom_Control(
        $wp_customize,
        'techbeeps_header_sticky',
        [
            'label' => __('Sticky Header', 'techbeeps'),
            'section' => 'header_custom_options',
            'settings' => 'techbeeps_header_sticky',
        ]
    ));

    // Transparent Header Setting
    $wp_customize->add_setting('techbeeps_header_transparent', [
        'default' => false,
        'sanitize_callback' => 'wp_validate_boolean',
    ]);
    $wp_customize->add_control(new Techbeeps_Toggle_Switch_Custom_Control(
        $wp_customize,
        'techbeeps_header_transparent',
        [
            'label' => __('Transparent Header', 'techbeeps'),
            'section' => 'header_custom_options',
            'settings' => 'techbeeps_header_transparent',
        ]
    ));

    // Padding
    $wp_customize->add_setting('techbeeps_header_padding', [
        'default' => wp_json_encode(['top' => '0', 'right' => '0', 'bottom' => '0', 'left' => '0']),
        'transport' => 'refresh',
        'sanitize_callback' => function ($input) {
            $decoded = json_decode($input, true);
            return wp_json_encode(array_map('sanitize_text_field', $decoded));
        }
    ]);
    $wp_customize->add_control(new Techbeeps_My_Customize_header_padding_Control($wp_customize, 'techbeeps_header_padding', [
        'label' => __('Padding (Top, Right, Bottom, Left)', 'techbeeps'),
        'section' => 'header_custom_options'
    ]));
}
add_action('customize_register', 'techbeeps_header_customize_register');

// Global customize options
function techbeeps_global_theme_settings($wp_customize)
{
    require_once TECHBEEPS_DIR . '/inc/custom-controls/class-global-control.php';

    // Global Theme Settings Panel
    $wp_customize->add_panel('techbeeps_theme_settings', [
        'title' => __('Global Settings', 'techbeeps'),
        'priority' => 10,
    ]);

    // ============ Global Colors ============
    $wp_customize->add_section('techbeeps_colors', [
        'title' => __('Colors', 'techbeeps'),
        'panel' => 'techbeeps_theme_settings',
    ]);

    $color_settings = [
        'primary_color' => ['label' => __('Primary Color', 'techbeeps'), 'default' => '#343fcd'],
        'secondary_color' => ['label' => __('Secondary Color', 'techbeeps'), 'default' => '#00c850'],
        'primary_bg_color' => ['label' => __('Primary Background Color', 'techbeeps'), 'default' => '#f2f2f2'],
        'secondary_bg_color' => ['label' => __('Secondary Background Color', 'techbeeps'), 'default' => '#ffffff'],
        'heading_color' => ['label' => __('Heading Color', 'techbeeps'), 'default' => '#333333'],
        'text_color' => ['label' => __('Text Color', 'techbeeps'), 'default' => '#666666'],
        'link_color' => ['label' => __('Link Color', 'techbeeps'), 'default' => '#4c4c4c'],
    ];
    // Loop through and add each color setting and control
    foreach ($color_settings as $key => $data) {
        $setting_id = 'techbeeps_' . $key;

        $wp_customize->add_setting($setting_id, array(
            'default'   => $data['default'],
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));

        $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, $setting_id, array(
            'label'    => $data['label'],
            'section'  => 'techbeeps_colors',
            'settings' => $setting_id,
        )));
    }

    // ============ Typography ============

    $wp_customize->add_section('techbeeps_typography', [
        'title' => __('Typography', 'techbeeps'),
        'panel' => 'techbeeps_theme_settings',
    ]);

    $wp_customize->add_setting('techbeeps_typography', [
        'default' => wp_json_encode([]),
        'transport' => 'refresh',
        'sanitize_callback' => function ($input) {
            $data = json_decode($input, true);
            return is_array($data) ? wp_json_encode($data) : wp_json_encode([]);
        },
    ]);

    $wp_customize->add_control(new Techbeeps_Global_Typography_Options(
        $wp_customize,
        'techbeeps_typography',
        [
            'label' => __('Typography', 'techbeeps'),
            'section' => 'techbeeps_typography', // Change section if needed
            'settings' => 'techbeeps_typography',
        ]
    ));

    // ============ Sidebar ============

    $wp_customize->add_section('techbeeps_sidebar', [
        'title' => __('Sidebar', 'techbeeps'),
        'panel' => 'techbeeps_theme_settings',
    ]);

    $wp_customize->add_setting('techbeeps_global_sidebar_layout', ['No Sidebar' => 'no sidebar', 'sanitize_callback' => 'sanitize_text_field']);
    $wp_customize->add_setting('techbeeps_global_sidebar_style', ['default' => 'unboxed', 'sanitize_callback' => 'sanitize_text_field']);
    $wp_customize->add_setting('techbeeps_sidebar_width', ['default' => '25', 'sanitize_callback' => 'absint']);
    $wp_customize->add_control(new Techbeeps_Global_Sidebar_Layout_Control($wp_customize, 'techbeeps_global_sidebar_layout', [
        'label'    => __('Select Sidebar Layout', 'techbeeps'),
        'section'  => 'techbeeps_sidebar',
        'settings' => 'techbeeps_global_sidebar_layout',

    ]));
    $wp_customize->add_setting('techbeeps_sidebar_sticky', [
        'default' => false,
        'sanitize_callback' => 'wp_validate_boolean',
    ]);
    $wp_customize->add_control(new Techbeeps_Toggle_Switch_Custom_Control(
        $wp_customize,
        'techbeeps_sidebar_sticky',
        [
            'label' => __('Sticky Sidebar', 'techbeeps'),
            'section' => 'techbeeps_sidebar',
            'settings' => 'techbeeps_sidebar_sticky',
        ]
    ));

    // ============ Layout ============
    $wp_customize->add_section('techbeeps_layout', [
        'title' => __('Layout', 'techbeeps'),
        'panel' => 'techbeeps_theme_settings',
    ]);
    $wp_customize->add_setting('techbeeps_global_layout', ['default' => 'container','sanitize_callback' => 'sanitize_text_field',]);
    $wp_customize->add_setting('techbeeps_global_layout_style', ['default' => 'unboxed','sanitize_callback' => 'sanitize_text_field']);
    $wp_customize->add_setting('techbeeps-container-width', ['default' => '1200','sanitize_callback' => 'absint']);
    $wp_customize->add_setting('techbeeps-narrow-container-width', ['default' => '750','sanitize_callback' => 'absint']);

    $layouts = [
        'full-width' => 'Full Width',
        'container' => 'Container',
        'narrow' => 'Narrow',
    ];

    $wp_customize->add_control(new Techbeeps_Global_Layout_Control($wp_customize, 'techbeeps_global_layout', [
        'label'    => __('Select Layout', 'techbeeps'),
        'section'  => 'techbeeps_layout',
        'settings' => ['techbeeps_global_layout', 'techbeeps_global_layout_style'],
        'choices' => $layouts,
    ]));


    // ============ Button ============
    $wp_customize->add_section('techbeeps_buttons', [
        'title' => __('Buttons', 'techbeeps'),
        'panel' => 'techbeeps_theme_settings',
    ]);

    // Border Width
    $wp_customize->add_setting('techbeeps_btn_layout_style', array(
        'default'   => 'default',
        'transport' => 'postMessage',
        'sanitize_callback' => 'sanitize_text_field',

    ));
    $wp_customize->add_control(new Techbeeps_Global_Button_Layout_Styles($wp_customize, 'techbeeps_btn_layout_style', array(
        'label'   => __('Button Border Width (px)', 'techbeeps'),
        'section' => 'techbeeps_buttons',
    )));
    // Button Text Color
    $wp_customize->add_setting('techbeeps_btn_txt_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',

    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_btn_txt_color', array(
        'label'    => __('Button Text Color', 'techbeeps'),
        'section'  => 'techbeeps_buttons',
    )));
    // Button Text Hover Color
    $wp_customize->add_setting('techbeeps_btn_hover_txt_color', array(
        'default'   => '#ffffff',
        'transport' => 'refresh',
         'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_btn_hover_txt_color', array(
        'label'    => __('Button Text Hover Color', 'techbeeps'),
        'section'  => 'techbeeps_buttons',
    )));

    // Button Background Color
    $wp_customize->add_setting('techbeeps_btn_bg_color', array(
        'default'   => '#343fcd',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_btn_bg_color', array(
        'label'    => __('Button Background Color', 'techbeeps'),
        'section'  => 'techbeeps_buttons',
    )));
    // Button Background Color hover
    $wp_customize->add_setting('techbeeps_btn_hover_bg_color', array(
        'default'   => '#00c850',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_btn_hover_bg_color', array(
        'label'    => __('Button Background Color', 'techbeeps'),
        'section'  => 'techbeeps_buttons',
    )));

    // Button Border Color
    $wp_customize->add_setting('techbeeps_btn_border_color', array(
        'default'   => '#00c850',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_btn_border_color', array(
        'label'    => __('Button Border Color', 'techbeeps'),
        'section'  => 'techbeeps_buttons',
    )));

    // Button Border Color hover
    $wp_customize->add_setting('techbeeps_btn_hover_border_color', array(
        'default'   => '#343fcd',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'techbeeps_btn_hover_border_color', array(
        'label'    => __('Button Border Color Hover', 'techbeeps'),
        'section'  => 'techbeeps_buttons',
    )));
    // Button Font Size
    $wp_customize->add_setting('techbeeps_btn_font_size', array(
        'default'   => '16',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
        
    ));
    $wp_customize->add_control(new Techbeeps_Global_Range_Control($wp_customize, 'techbeeps_btn_font_size', array(
        'label'   => __('Button Font Size', 'techbeeps'),
        'section' => 'techbeeps_buttons',
    )));
    // Padding
    $wp_customize->add_setting('techbeeps_btn_padding', array(
        'default'   => '10px 20px 10px 20px',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',

    ));
    $wp_customize->add_control(new Techbeeps_Global_Button_Input_Control($wp_customize, 'techbeeps_btn_padding', array(
        'label'   => __('Button Padding (px)', 'techbeeps'),
        'section' => 'techbeeps_buttons',
    )));

    // Border Radius
    $wp_customize->add_setting('techbeeps_btn_radius', array(
        'default'   => '5px 5px 5px 5px',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',

    ));
    $wp_customize->add_control(new Techbeeps_Global_Button_Input_Control($wp_customize, 'techbeeps_btn_radius', array(
        'label'   => __('Button Border Radius (px)', 'techbeeps'),
        'section' => 'techbeeps_buttons',
    )));

    // Border Width
    $wp_customize->add_setting('techbeeps_btn_border_width', array(
        'default'   => '1px 1px 1px 1px',
        'transport' => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Techbeeps_Global_Button_Input_Control($wp_customize, 'techbeeps_btn_border_width', array(
        'label'   => __('Button Border Width (px)', 'techbeeps'),
        'section' => 'techbeeps_buttons',
    )));
}
add_action('customize_register', 'techbeeps_global_theme_settings');
