<?php

/**
 * techbeeps custom functions and definitions
 *
 * @package techbeeps
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

add_filter('body_class', 'techbeeps_add_sidebar_style_class');
function techbeeps_add_sidebar_style_class($classes)
{
    $style_da = get_post_meta(get_the_ID(), '_techbeeps_container_style', true) ?: 'Default';
    $disable_banner = get_post_meta(get_the_ID(), '_techbeeps_disable_banner', true) ? 'techbeeps-no-banner' : '';
    $page_layout = strtolower($style_da == 'Default' ? get_theme_mod('techbeeps_global_layout_style', 'Unboxed') : $style_da);
    $sidebar_style = strtolower(get_post_meta(get_the_ID(), '_techbeeps_sidebar_style', true) ?: 'Default');
    $sidebar_style = $sidebar_style == 'default' ? get_theme_mod('techbeeps_global_sidebar_style', 'Unboxed') : $sidebar_style;
    if ($page_layout == 'boxed' && (!is_home() && !is_single())) {
        $classes[] = 'layout-boxed';
    }
    if ($sidebar_style == 'boxed' && !is_single()) {
        $classes[] = 'layout-sidebar-boxed';
    }
    if (is_tax('product_cat', 'uncategorized')) {
        $classes[] = 'techbeeps-product-cat';
    }
    if (!$disable_banner && is_page()) {
        $classes[] = 'techbeeps-no-banner';
    }
    return $classes;
}
// Register widget areas
function techbeeps_theme_widgets_init()
{
    register_sidebar(array(
        'name'          => esc_html__('Sidebar', 'techbeeps'),
        'id'            => 'sidebar-1',
        'description'   => esc_html__('Add widgets here to appear in your sidebar.', 'techbeeps'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer Column 1', 'techbeeps'),
        'id'            => 'footer-1',
        'description'   => esc_html__('Add widgets here to appear in your footer.', 'techbeeps'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer Column 2', 'techbeeps'),
        'id'            => 'footer-2',
        'description'   => esc_html__('Add widgets here to appear in your footer.', 'techbeeps'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer Column 3', 'techbeeps'),
        'id'            => 'footer-3',
        'description'   => esc_html__('Add widgets here to appear in your footer.', 'techbeeps'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Footer Column 4', 'techbeeps'),
        'id'            => 'footer-4',
        'description'   => esc_html__('Add widgets here to appear in your footer.', 'techbeeps'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => esc_html__('Header After Nav', 'techbeeps'),
        'id'            => 'header-after-nav',
        'description'   => esc_html__('Add widgets here to appear in your footer.', 'techbeeps'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widget-title">',
        'after_title'   => '</h2>',
    ));
}
add_action('widgets_init', 'techbeeps_theme_widgets_init');
// Set up theme defaults and register support for WordPress features
function techbeeps_theme_setup()
{


    load_theme_textdomain('techbeeps', TECHBEEPS_DIR . '/languages');
    add_theme_support('automatic-feed-links');
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('elementor');
    add_theme_support('align-wide');
    add_theme_support('wp-block-styles');
    add_theme_support('responsive-embeds');

    // Register menus
    register_nav_menus(array(
        'primary' => esc_html__('Primary Menu', 'techbeeps'),
        'footer' => esc_html__('Footer Menu', 'techbeeps'),
        'mobile'  => __('Mobile Menu', 'techbeeps'),

    ));
    // Switch default core markup to output valid HTML5
    add_theme_support('html5', array(
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
    ));
    // Add theme support for selective refresh for widgets
    add_theme_support('customize-selective-refresh-widgets');
    // Add support for core custom logo
    add_theme_support('custom-logo', array(
        'height'      => 100,
        'width'       => 100,
        'flex-width'  => true,
        'flex-height' => true,
    ));
    // Add support for Elementor
    add_theme_support('elementor', array(
        'title' => esc_html__('techbeeps', 'techbeeps'),
        'description' => esc_html__('A theme designed for Elementor.', 'techbeeps'),
        'version' => TECHBEEPS_VERSION,
    ));
    //Add support for custom background
    add_theme_support('custom-background', [
        'default-color' => 'ffffff',
        'default-image' => '',
        'wp-head-callback' => '_custom_background_cb',
    ]);
}
add_action('after_setup_theme', 'techbeeps_theme_setup');
function techbeeps_exclude_pages_from_search($query)
{
    if ($query->is_search() && $query->is_main_query() && !is_admin()) {
        if ($query->get('post_type') !== 'product') {
            $query->set('post_type', 'post');
        }
    }
}
add_action('pre_get_posts', 'techbeeps_exclude_pages_from_search');

function techbeeps_add_editor_styles()
{
    add_editor_style('editor-style.css');
}
add_action('admin_init', 'techbeeps_add_editor_styles');
// Remove or change the "more" text from the_excerpt
function techbeeps_enqueue_google_font()
{

    //All fonts are loaded from https://fonts.googleapis.com and are licensed under GPL-compatible open source licenses.
    $fonts_family = ['Arial', 'Helvetica', 'Times New Roman', 'Georgia', 'Courier New', 'Verdana', 'Tahoma'];
    $techbeeps_typography_json = get_theme_mod('techbeeps_typography', '[]');
    $techbeeps_typography = json_decode($techbeeps_typography_json, true);
    $techbeeps_typography = is_array($techbeeps_typography) ? $techbeeps_typography : [];
    $font_family = esc_attr($techbeeps_typography['body']['font_family'] ?? 'Arial, sans-serif');
    $h_font_family = esc_attr($techbeeps_typography['heading']['font_family'] ?? 'Arial, sans-serif');
    $font_family = explode(',', $font_family)[0];
    $h_font_family = explode(',', $h_font_family)[0];
    $fonts_url = 'https://fonts.googleapis.com/css2?';
    $font_families = array();

    if (!in_array($font_family, $fonts_family)) {
        $font_families[] = "family=$font_family:wght@400;600";
    }
    if (!in_array($h_font_family, $fonts_family) && $font_family != $h_font_family) {
        $font_families[] = "family=$h_font_family:wght@400;600";
    }
    $fonts_url .= implode('&', $font_families) . '&display=swap';
    if (empty($font_families)) {
        return;
    }
    wp_enqueue_style('google-fonts', esc_url($fonts_url), array(), null);
}

function techbeeps_excerpt_more($more)
{
    return '...';
}
add_filter('excerpt_more', 'techbeeps_excerpt_more');

function techbeeps_get_layout_classes()
{
    $page_layout = get_post_meta(get_the_ID(), '_techbeeps_page_layout', true) ?: 'default';
    $sidebar_layout = get_post_meta(get_the_ID(), '_techbeeps_sidebar_layout', true) ?: 'default';
    $techbeeps_global_sidebar_layout = get_theme_mod('techbeeps_global_sidebar_layout', 'no-sidebar');
    $sidebar_layout = $sidebar_layout == 'default' ? $techbeeps_global_sidebar_layout : $sidebar_layout;
    $page_layout = $page_layout == 'default' ? get_theme_mod('techbeeps_global_layout', 'container') : $page_layout;
    return 'techbeeps-' . $sidebar_layout . ' techbeeps-wrapper-' . $page_layout;
}

// Set default number of posts per page when theme is activated
function techbeeps_set_default_posts_per_page() {
    // Update the 'posts_per_page' option in WordPress settings
    update_option( 'posts_per_page', 9 );
}
add_action( 'after_switch_theme', 'techbeeps_set_default_posts_per_page' );
