// Path: inc/custom-controls/js/global-sidebar-controls.js
// This file is used to handle the global layout icons     
jQuery(document).ready(function ($) {
    $('.global-layout-icons .global-layout-icon').on('click', function () {
        $('.global-layout-icons .global-layout-icon').removeClass('selected');
        $(this).addClass('selected');
        var value = $(this).data('value');
        $(this).closest('label').find('input[type=hidden]').val(value).trigger('change');
    });

    $('.techbeeps-container-width-reset').on('click', function () {
        $('#techbeeps-container-width-value, #techbeeps-container-width').val(1200).trigger('change');
    });
    $('.techbeeps-narrow-container-width-reset').on('click', function () {
        $('#techbeeps-narrow-container-width-value, #techbeeps-narrow-container-width').val(750).trigger('change');
    });

    $('#techbeeps-container-width').on('change', function () {
        $('#techbeeps-container-width-value').val($(this).val()).trigger('change');
    });

    $('#techbeeps-narrow-container-width').on('change', function () {
        $('#techbeeps-narrow-container-width-value').val($(this).val()).trigger('change');
    });
    $('input[name="techbeeps_container_style"]').on('change', function () {
        $('#techbeeps_global_layout_style').val($(this).val()).trigger('change');
    });


});


// // This file is used to handle the global sidebar layout icons
jQuery(document).ready(function ($) {
    $('.global-sidebar-layout-icons .global-sidebar-layout-icon').on('click', function () {
        $('.global-sidebar-layout-icons .global-sidebar-layout-icon').removeClass('selected');
        $(this).addClass('selected');
        var value = $(this).data('value');
        $(this).closest('label').find('input[type=hidden]').val(value).trigger('change');
    });
});

// This file is used to handle the typography control
(function ($) {
    $(document).ready(function () {
        $('.techbeeps-typography-control').each(function () {
            const $container = $(this);
            const updateHidden = () => {
                let data = { body: {}, heading: {} };
                $('.techbeeps-typography-control.body').find('input, select, textarea').each(function () {
                    let $field = $(this);
                    let key = $field.attr('data-id');
                    let value = $field.val();

                    data['body'][key] = value;
                });
                $('.techbeeps-typography-control.headings').find('input, select, textarea').each(function () {
                    let $field = $(this);
                    let key = $field.attr('data-id');
                    let value = $field.val();

                    data['heading'][key] = value;
                });
                $('.techbeeps-typography-hidden').val(JSON.stringify(data)).trigger('change');
            };

            $container.find('select,  input[type=range]').on('change input', updateHidden);
        });
    });
})(jQuery);

// range  controles result
(function ($) {
    $(document).ready(function () {
        $('.techbeeps-range-control input[type="range"]').on('input change', function () {
            var value = $(this).val();
            $(this).next('.range-value').text(value + 'px');


        });
    });
})(jQuery);


//  typography tab 
jQuery(document).ready(function ($) {
    $('.techbeeps-body-tab').on('click', function () {
        // Remove active class from all tabs
        $('.techbeeps-heading-tab').removeClass('active');
        $(this).addClass('active');
        $('.techbeeps-typography-control.body').show();
        $('.techbeeps-typography-control.headings').hide();
    });
    $('.techbeeps-heading-tab').on('click', function () {
        // Remove active class from all tabs
        $('.techbeeps-body-tab').removeClass('active');
        $(this).addClass('active');
        $('.techbeeps-typography-control.body').hide();
        $('.techbeeps-typography-control.headings').show();
    });
});

// button padding, radius and border width controls
(function ($) {
    var techbeeps_customizer = ['techbeeps_btn_padding', 'techbeeps_btn_radius', 'techbeeps_btn_border_width'];
    techbeeps_customizer.forEach(element => {
        wp.customize(element, function (value) {
            const inputs = jQuery('.' + element);
            inputs.on('input', function () {
                let result = inputs.map(function () {
                    return jQuery(this).val() + "px";
                }).get().join(' ');
                value.set(result);
            });
        });
    });
})(jQuery);

(function ($) {
    wp.customize('techbeeps_btn_layout_style', function (value) {
        value.bind(function (selectedStyle) {
            // Define preset styles
            const styles = {
                default: {
                    techbeeps_btn_txt_color: '#ffffff',
                    techbeeps_btn_hover_txt_color: '#ffffff',
                    techbeeps_btn_bg_color: '#343fcd',
                    techbeeps_btn_hover_bg_color: '#00c850',
                    techbeeps_btn_border_color: '#00c850',
                    techbeeps_btn_hover_border_color: '#343fcd',
                    techbeeps_btn_font_size: '16',
                    techbeeps_btn_padding: '10px 20px 10px 20px',
                    techbeeps_btn_radius: '5px 5px 5px 5px',
                    techbeeps_btn_border_width: '1px 1px 1px 1px',
                },
                flat: {
                    techbeeps_btn_txt_color: '#ffffff',
                    techbeeps_btn_hover_txt_color: '#eeeeee',
                    techbeeps_btn_bg_color: '#343fcd',
                    techbeeps_btn_hover_bg_color: '#222ca7',
                    techbeeps_btn_border_color: '#343fcd',
                    techbeeps_btn_hover_border_color: '#222ca7',
                    techbeeps_btn_font_size: '16',
                    techbeeps_btn_padding: '10px 25px 10px 25px',
                    techbeeps_btn_radius: '0px 0px 0px 0px',
                    techbeeps_btn_border_width: '0px 0px 0px 0px',
                },
                rounded: {
                    techbeeps_btn_txt_color: '#ffffff',
                    techbeeps_btn_hover_txt_color: '#ffffff',
                    techbeeps_btn_bg_color: '#343fcd',
                    techbeeps_btn_hover_bg_color: '#222ca7',
                    techbeeps_btn_border_color: '#343fcd',
                    techbeeps_btn_hover_border_color: '#222ca7',
                    techbeeps_btn_font_size: '18',
                    techbeeps_btn_padding: '12px 30px 12px 30px',
                    techbeeps_btn_radius: '30px 30px 30px 30px',
                    techbeeps_btn_border_width: '1px 1px 1px 1px',
                },
                outline: {
                    techbeeps_btn_txt_color: '#343fcd',
                    techbeeps_btn_hover_txt_color: '#ffffff',
                    techbeeps_btn_bg_color: '#ffffff',
                    techbeeps_btn_hover_bg_color: '#343fcd',
                    techbeeps_btn_border_color: '#343fcd',
                    techbeeps_btn_hover_border_color: '#343fcd',
                    techbeeps_btn_font_size: '16',
                    techbeeps_btn_padding: '10px 20px 10px 20px',
                    techbeeps_btn_radius: '4px 4px 4px 4px',
                    techbeeps_btn_border_width: '2px 2px 2px 2px',
                },
                rounded_outline: {
                    techbeeps_btn_txt_color: '#343fcd',
                    techbeeps_btn_hover_txt_color: '#ffffff',
                    techbeeps_btn_bg_color: '#ffffff',
                    techbeeps_btn_hover_bg_color: '#343fcd',
                    techbeeps_btn_border_color: '#343fcd',
                    techbeeps_btn_hover_border_color: '#343fcd',
                    techbeeps_btn_font_size: '16',
                    techbeeps_btn_padding: '10px 20px 10px 20px',
                    techbeeps_btn_radius: '20px 20px 20px 20px',
                    techbeeps_btn_border_width: '2px 2px 2px 2px',
                },


            };

            const selectedPreset = styles[selectedStyle];

            Object.keys(selectedPreset).forEach(function (settingId) {
                wp.customize(settingId).set(selectedPreset[settingId]);
                padding = selectedPreset.techbeeps_btn_padding.split("px")
                btn_width = selectedPreset.techbeeps_btn_border_width.split("px")
                btn_radius = selectedPreset.techbeeps_btn_radius.split("px")


                $('#customize-control-techbeeps_btn_padding input').each(function (index) {
                    $(this).val(padding[index].trim())
                })
                $('#customize-control-techbeeps_btn_border_width input').each(function (index) {
                    $(this).val(btn_width[index].trim())
                });

                $('#customize-control-techbeeps_btn_radius input').each(function (index) {
                    $(this).val(btn_radius[index].trim())
                });

                $('#customize-control-techbeeps_btn_font_size .range-value').text(selectedPreset.techbeeps_btn_font_size + 'px');

            });
        });
    });
}
)(jQuery);


jQuery(document).ready(function ($) {

    $('input[name="techbeeps_sidebar_style"]').on('change', function () {
        $('#techbeeps_global_sidebar_style').val($(this).val()).trigger('change');
    });

    $('.techbeeps_sidebar_width_reset').on('click', function () {
        $('#techbeeps_sidebar_width_value, #techbeeps_sidebar_width').val(25).trigger('change');
    });

    $('#techbeeps_sidebar_width').on('change', function () {
        $('#techbeeps_sidebar_width_value').val($(this).val()).trigger('change');
    });

});
