<?php
/** 
 * Custom Controls for Header Layout in WordPress Customizer
 *
 * @package TechBeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (class_exists('WP_Customize_Control')) {
    class Techbeeps_My_Customize_header_padding_Control extends WP_Customize_Control
    {
        public $type = 'techbeeps_header_padding';
        public function enqueue()
        {
            wp_enqueue_script(
                'techbeeps-header-control-js',
                get_template_directory_uri() . '/inc/custom-controls/js/header-control.js',
                ['jquery'],
                null,
                true
            );
        }
        public function render_content()
        {
            $control_id = esc_attr($this->id);
            $value = json_decode($this->value(), true);
            $labels =  [
                'top'    => 'Top',
                'right'  => 'Right',
                'bottom' => 'Bottom',
                'left'   => 'Left',
            ];

           
?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span></label>
            <div class="techbeeps-global-input-control header-padding-inputs" data-control-id="<?php echo esc_attr($control_id); ?>" style="display: flex; gap: 5px; margin-top: 5px;">
                <?php foreach ($labels as $side => $label) : ?>
                    <div>
                        <input type="number" value="<?php echo esc_attr($value[$side] ?? '0'); ?>"
                            data-side="<?php echo esc_attr($side); ?>" />
                        <label><?php echo esc_html($label); ?></label>
                    </div>
                <?php
                endforeach; ?>
                <input type="hidden" <?php $this->link(); ?> id="<?php echo esc_attr($control_id); ?>-input" value="<?php echo esc_attr(wp_json_encode($value)); ?>">
            </div>
        <?php
        }
    }
    class Techbeeps_Toggle_Switch_Custom_Control extends WP_Customize_Control
    {
        public $type = 'toggle_switch';
        public function enqueue()
        {
           wp_enqueue_style('techbeeps-header-controls-css', TECHBEEPS_URL . '/inc/custom-controls/css/header-controls.css');
        }
        public function render_content()
        {
        ?>
            <div class="toggle-switch-custom-control">
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <label class="switch">
                    <input type="checkbox" value="1" <?php $this->link(); ?> <?php checked($this->value(), 1); ?> />
                    <span class="slider round"></span>
                </label>
            </div>
        <?php
        }
    }
    class Techbeeps_Layout_Radio_Image_Control extends WP_Customize_Control
    {
        public $type = 'layout_radio_image';
        public function render_content()
        {
            if (empty($this->choices)) return;
        ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <div class="layout-radio-options">
                    <?php foreach ($this->choices as $value => $label) : ?>
                        <label class="layout-radio-option">
                            <input type="radio" name="<?php echo esc_attr($this->id); ?>" value="<?php echo esc_attr($value); ?>" <?php $this->link();                                                                                                                                    checked($this->value(), $value); ?> />
                            <div class="layout-graphic layout-<?php echo esc_attr($value); ?>">
                                <div class="bar1">
                                    <div class="techbeeps-layout-line1"></div>
                                    <div class="techbeeps-layout-line"></div>
                                    <div class="techbeeps-layout-line"></div>
                                    <div class="techbeeps-layout-line"></div>
                                    <div class="techbeeps-layout-line"></div>
                                </div>
                            </div>
                            <span><?php echo esc_html($label); ?></span>
                        </label>
                    <?php endforeach; ?>
                </div>
            </label>
<?php
        }
    }
}
