<?php

/**
 * Customizer Global Layout Control
 *
 * @package Techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (class_exists('WP_Customize_Control')) {
    class Techbeeps_Global_Layout_Control extends WP_Customize_Control
    {
        public $type = 'global_layout_icons';
        public function enqueue()
        {
            wp_enqueue_script('techbeeps-global-controls-js', TECHBEEPS_URL . '/inc/custom-controls/js/global-controls.js', ['jquery'], null, true);
            wp_enqueue_style('techbeeps-global-controls-css', TECHBEEPS_URL . '/inc/custom-controls/css/global-controls.css');
        }
        public function render_content()
        { ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <div class="global-layout-icons">
                    <?php
                    foreach ($this->choices as $value => $label): ?>
                        <div class="techbeeps-layout-<?php echo esc_attr($value); ?> global-layout-icon <?php echo ($this->get_value('techbeeps_global_layout') === $value) ? 'selected' : '' ?>"
                            data-value="<?php echo esc_attr($value); ?>"
                            title="<?php echo esc_attr($label); ?>">
                            <div class="techbeeps-layout-line1"></div>
                            <div class="techbeeps-layout-line"></div>
                            <div class="techbeeps-layout-line"></div>
                            <div class="techbeeps-layout-line"></div>
                            <div class="techbeeps-layout-line"></div>
                            <span class="techbeeps-layout-tooltips"><?php echo esc_html($label); ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
                <input type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr($this->get_value('techbeeps_global_layout')); ?>" />
            </label>
            <div class="techbeeps-container-style techbeeps-global-layout-control">
                <label for="techbeeps-container-style"> <span class="customize-control-title"><?php _e('Container Style', 'techbeeps') ?> </span></label>
                <input type="radio" id="unboxed" value="unboxed" name="techbeeps_container_style" <?php checked(esc_attr($this->get_value('techbeeps_global_layout_style')), 'unboxed')    ?>>
                <input type="radio" id="boxed" value="boxed" name="techbeeps_container_style" <?php checked(esc_attr($this->get_value('techbeeps_global_layout_style')), 'boxed')    ?>>
                <input type="hidden" id="techbeeps_global_layout_style" value="<?php echo esc_attr($this->get_value('techbeeps_global_layout_style')); ?>" data-customize-setting-link="techbeeps_global_layout_style" />
                <div class="techbeeps-container-style-labels">
                    <label for="unboxed"><?php _e('Unboxed', 'techbeeps') ?></label>
                    <label for="boxed"><?php _e('Boxed', 'techbeeps') ?></label>
                    <div class="techbeeps-toggle-slider"></div>
                </div>
            </div>
            <div class="techbeeps-global-container-range techbeeps-global-layout-control techbeeps-range-control">
                <div class="techbeeps-global-container-width">
                    <label for="techbeeps-container-width"><span class="techbeeps-control-title"><?php _e('Container Width', 'techbeeps') ?></span></label>
                    <div class="techbeeps-slider-wrapper">
                        <input type="range" id="techbeeps-container-width" min="600" max="2000" value="<?php echo esc_attr($this->get_value('techbeeps-container-width')); ?>">
                        <input type="number" id="techbeeps-container-width-value" value="<?php echo esc_attr($this->get_value('techbeeps-container-width')); ?>" data-customize-setting-link="techbeeps-container-width">
                        <span>px</span> <span class="techbeeps-container-width-reset"><svg width="15px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path d="M22.719 12A10.719 10.719 0 0 1 1.28 12h.838a9.916 9.916 0 1 0 1.373-5H8v1H2V2h1v4.2A10.71 10.71 0 0 1 22.719 12z" />
                                <path fill="none" d="M0 0h24v24H0z" />
                            </svg>
                        </span>
                    </div>
                </div>
                <div class="techbeeps-global-container-width ">
                    <label for="techbeeps-narrow-container-width"><span class="techbeeps-control-title"><?php _e('Narrow Container Width', 'techbeeps') ?></span></label>
                    <div class="techbeeps-slider-wrapper">
                        <input type="range" id="techbeeps-narrow-container-width" min="400" max="1500" value="<?php echo esc_attr($this->get_value('techbeeps-narrow-container-width')); ?>">
                        <input type="number" id="techbeeps-narrow-container-width-value" value="<?php echo esc_attr($this->get_value('techbeeps-narrow-container-width')); ?>" data-customize-setting-link="techbeeps-narrow-container-width">
                        <span>px</span> <span class="techbeeps-narrow-container-width-reset"><svg width="15px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path d="M22.719 12A10.719 10.719 0 0 1 1.28 12h.838a9.916 9.916 0 1 0 1.373-5H8v1H2V2h1v4.2A10.71 10.71 0 0 1 22.719 12z" />
                                <path fill="none" d="M0 0h24v24H0z" />
                            </svg>
                        </span>
                    </div>
                </div>
            </div>
        <?php
        }
        private function get_value($setting_id)
        {
            return $this->manager->get_setting($setting_id)->value();
        }
    }

    class Techbeeps_Global_Typography_Options extends WP_Customize_Control
    {
        public $type = 'techbeeps_typography';
        public $fonts = [];
        public $weights = ['100', '200', '300', '400', '500', '600', '700', '800', '900'];
        public $transforms = ['None' => 'none', 'Uppercase' => 'uppercase', 'Lowercase' => 'lowercase', 'Capitalize' => 'capitalize'];
        public $font_styles = ['Regular' => 'normal', 'Italic' => 'italic', 'Oblique' => 'oblique'];
        public $text_decorations = ['None', 'Underline', 'Overline', 'Line-through', 'Underline Overline'];
        public $fonts_family = [
            'Arial, sans-serif' => 'Arial',
            'Helvetica, sans-serif' => 'Helvetica',
            'Times New Roman, serif' => 'Times New Roman',
            'Georgia, serif' => 'Georgia',
            'Courier New, monospace' => 'Courier New',
            'Verdana, sans-serif' => 'Verdana',
            'Tahoma, sans-serif' => 'Tahoma'
        ];
        public function render_content()
        {
            $google_fonts_json = file_get_contents(TECHBEEPS_DIR . '/inc/custom-controls/js/google-fonts.json');
            $google_fonts = json_decode($google_fonts_json, true);
            $value = json_decode($this->value(), true);
            $value = is_array($value) ? $value : [];
            // Body values
            $font_family = esc_attr($value['body']['font_family'] ?? 'Arial, sans-serif');
            $font_weight = esc_attr($value['body']['font_weight'] ?? '400');
            $text_transform = esc_attr($value['body']['text_transform'] ?? 'none');
            $font_size = esc_attr($value['body']['font_size'] ?? 16);
            $line_height = esc_attr($value['body']['line_height'] ?? 1.6);
            $word_spacing = esc_attr($value['body']['word_spacing'] ?? 0);
            $font_styles = esc_attr($value['body']['font_style'] ?? 'normal');
            $text_decoration = esc_attr($value['body']['text_decoration'] ?? 'none');
            $paragraph_m_bottom = esc_attr($value['body']['paragraph_m_bottom'] ?? 0.5);
            // Heading values
            $h_font_family = esc_attr($value['heading']['font_family'] ?? 'Arial, sans-serif');
            $h_font_weight = esc_attr($value['heading']['font_weight'] ?? '600');
            $h_text_transform = esc_attr($value['heading']['text_transform'] ?? 'none');
            $h_line_height = esc_attr($value['heading']['line_height'] ?? 1.6);
            $h_word_spacing = esc_attr($value['heading']['word_spacing'] ?? 0);
            $h_font_styles = esc_attr($value['heading']['font_style'] ?? 'normal');
            $h_text_decoration = esc_attr($value['heading']['text_decoration'] ?? 'none');
            $h1_font_size = esc_attr($value['heading']['heading_1_fs'] ?? 48);
            $h2_font_size = esc_attr($value['heading']['heading_2_fs'] ?? 36);
            $h3_font_size = esc_attr($value['heading']['heading_3_fs'] ?? 30);
            $h4_font_size = esc_attr($value['heading']['heading_4_fs'] ?? 28);
            $h5_font_size = esc_attr($value['heading']['heading_5_fs'] ?? 26);
            $h6_font_size = esc_attr($value['heading']['heading_6_fs'] ?? 18);

        ?>
            <div class="">
                <div class="techbeeps-tab-global-container">
                    <div class="techbeeps-tab-global techbeeps-body-tab active"> Body</div>
                    <div class="techbeeps-tab-global techbeeps-heading-tab">Heading</div>
                </div>
            </div>
            <div class="techbeeps-typography-control techbeeps-range-control body">
                <label><?php _e('Body', 'techbeeps') ?></label>

                <label> <?php _e('Font Family', 'techbeeps') ?></label>
                <select class="techbeeps-font-family" data-id="font_family">
                    <optgroup label="<?php _e('System Fonts', 'techbeeps') ?>">
                        <?php foreach ($this->fonts_family as $value => $label) : ?>
                            <option value="<?php echo esc_attr($value); ?>" style="font-family: <?php echo esc_attr($value); ?>" <?php selected($font_family, $value); ?>>
                                <?php echo esc_html($label); ?>
                            </option>
                        <?php endforeach; ?>
                    </optgroup>
                    <optgroup label="<?php _e('Google Fonts', 'techbeeps') ?>">
                        <?php foreach ($google_fonts as $value => $label) : ?>
                            <option value="<?php echo esc_attr($value); ?>" style="font-family: <?php echo esc_attr($value); ?>" <?php selected($font_family, $value); ?>>
                                <?php echo esc_html($label); ?>
                            </option>
                        <?php endforeach; ?>
                    </optgroup>
                </select>
                <div class="techbeeps-typography-options">
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Font Weight', 'techbeeps') ?></label>
                        <select class="techbeeps-font-weight" data-id="font_weight">
                            <?php foreach ($this->weights as $weight) : ?>
                                <option value="<?php echo esc_attr($weight); ?>" <?php selected($font_weight, $weight); ?>><?php echo esc_html($weight); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Text Transform', 'techbeeps') ?></label>
                        <select class="techbeeps-text-transform" data-id="text_transform">
                            <?php foreach ($this->transforms as $transform) : ?>
                                <option value="<?php echo esc_attr($transform); ?>" <?php selected($text_transform, $transform); ?>><?php echo esc_html($transform); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Font Style', 'techbeeps') ?></label>
                        <select class="techbeeps-font-style" data-id="font_style">
                            <?php foreach ($this->font_styles as $font_style => $key) : ?>
                                <option value="<?php echo esc_attr($key); ?>" <?php selected($font_styles, $key); ?>><?php echo esc_html($font_style); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Text Decoration', 'techbeeps') ?></label>
                        <select class="techbeeps-text-decoration" data-id="text_decoration">
                            <?php foreach ($this->text_decorations as $decoration) : ?>
                                <option value="<?php echo esc_attr($decoration); ?>" <?php selected($text_decoration, $decoration); ?>><?php echo esc_html($decoration); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <label><?php _e('Font Size (px)', 'techbeeps') ?></label>
                <input data-id="font_size" type="range" min="5" max="80" step="1" value="<?php echo esc_attr($font_size); ?>" class="techbeeps-font-size">
                <span class="range-value"><?php echo esc_html($font_size); ?>px</span>
                <label><?php _e('Line Height', 'techbeeps') ?></label>
                <input data-id="line_height" type="range" min="1" max="10" step="0.1" value="<?php echo esc_attr($line_height); ?>" class="techbeeps-line-height">
                <span class="range-value"><?php echo esc_html($line_height); ?></span>
                <label><?php _e('Word Spacing', 'techbeeps') ?></label>
                <input data-id="word_spacing" type="range" min="1" max="10" step="0.1" value="<?php echo esc_attr($word_spacing); ?>" class="techbeeps-word-spacing">
                <span class="range-value"><?php echo esc_html($word_spacing); ?>px</span>
                <label><?php _e('Paragraph Margin Bottom', 'techbeeps') ?></label>
                <input data-id="paragraph_m_bottom" type="range" min="1" max="10" step="0.1" value="<?php echo esc_attr($paragraph_m_bottom); ?>" class="techbeeps-word-spacing">
                <span class="range-value"><?php echo esc_html($paragraph_m_bottom); ?>px</span>
            </div>
            <div class="techbeeps-typography-control techbeeps-range-control headings">
                <label><?php _e('Headings', 'techbeeps') ?></label>
                <label><?php _e('Font Family', 'techbeeps') ?></label>
                <select class="techbeeps-font-family" data-id="font_family">
                    <optgroup label="<?php _e('System Fonts', 'techbeeps') ?>">
                        <?php foreach ($this->fonts_family as $value => $label) : ?>
                            <option value="<?php echo esc_attr($value); ?>" style="font-family: <?php echo esc_attr($value); ?>" <?php selected($h_font_family, $value); ?>>
                                <?php echo esc_html($label); ?>
                            </option>
                        <?php endforeach; ?>
                    </optgroup>
                    <optgroup label="<?php _e('Google Fonts', 'techbeeps') ?>">
                        <?php foreach ($google_fonts as $value => $label) : ?>
                            <option value="<?php echo esc_attr($value); ?>" style="font-family: <?php echo esc_attr($value); ?>" <?php selected($h_font_family, $value); ?>>
                                <?php echo esc_html($label); ?>
                            </option>
                        <?php endforeach; ?>
                    </optgroup>
                </select>
                <div class="techbeeps-typography-options">
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Font Weight', 'techbeeps') ?></label>
                        <select class="techbeeps-font-weight" data-id="font_weight">
                            <?php foreach ($this->weights as $weight) : ?>
                                <option value="<?php echo esc_attr($weight); ?>" <?php selected($h_font_weight, $weight); ?>><?php echo esc_html($weight); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Text Transform', 'techbeeps') ?></label>
                        <select class="techbeeps-text-transform" data-id="text_transform">
                            <?php foreach ($this->transforms as $transform) : ?>
                                <option value="<?php echo esc_attr($transform); ?>" <?php selected($h_text_transform, $transform); ?>><?php echo esc_html($transform); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Font Style', 'techbeeps') ?></label>
                        <select class="techbeeps-font-style" data-id="font_style">
                            <?php foreach ($this->font_styles as $font_style => $key) : ?>
                                <option value="<?php echo esc_attr($key); ?>" <?php selected($h_font_styles, $key); ?>><?php echo esc_html($font_style); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="techbeeps-typography-selectors">
                        <label><?php _e('Text Decoration', 'techbeeps') ?></label>
                        <select class="techbeeps-text-decoration" data-id="text_decoration">
                            <?php foreach ($this->text_decorations as $decoration) : ?>
                                <option value="<?php echo esc_attr($decoration); ?>" <?php selected($h_text_decoration, $decoration); ?>><?php echo esc_html($decoration); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <label><?php _e('Line Height', 'techbeeps') ?></label>
                <input data-id="line_height" type="range" min="1" max="10" step="0.1" value="<?php echo esc_attr($h_line_height); ?>" class="techbeeps-line-height">
                <span class="range-value"><?php echo esc_html($h_line_height); ?></span>
                <label><?php _e('Word Spacing', 'techbeeps') ?></label>
                <input data-id="word_spacing" type="range" min="1" max="10" step="0.1" value="<?php echo esc_attr($h_word_spacing); ?>" class="techbeeps-word-spacing">
                <span class="range-value"><?php echo esc_html($h_word_spacing); ?>px</span>
                <label><?php _e('Heading 1', 'techbeeps') ?></label>
                <input data-id="heading_1_fs" type="range" min="5" max="90" step="1" value="<?php echo esc_attr($h1_font_size); ?>" class="techbeeps-heading-1-font-size">
                <span class="range-value"><?php echo esc_html($h1_font_size); ?>px</span>
                <label><?php _e('Heading 2', 'techbeeps') ?></label>
                <input data-id="heading_2_fs" type="range" min="5" max="80" step="1" value="<?php echo esc_attr($h2_font_size); ?>" class="techbeeps-heading-2-font-size">
                <span class="range-value"><?php echo esc_html($h2_font_size); ?>px</span>
                <label><?php _e('Heading 3', 'techbeeps') ?></label>
                <input data-id="heading_3_fs" type="range" min="5" max="80" step="1" value="<?php echo esc_attr($h3_font_size); ?>" class="techbeeps-heading-3-font-size">
                <span class="range-value"><?php echo esc_html($h3_font_size); ?>px</span>
                <label><?php _e('Heading 4', 'techbeeps') ?></label>
                <input data-id="heading_4_fs" type="range" min="5" max="80" step="1" value="<?php echo esc_attr($h4_font_size); ?>" class="techbeeps-heading-4-font-size">
                <span class="range-value"><?php echo esc_html($h4_font_size); ?>px</span>
                <label><?php _e('Heading 5', 'techbeeps') ?></label>
                <input data-id="heading_5_fs" type="range" min="5" max="80" step="1" value="<?php echo esc_attr($h5_font_size); ?>" class="techbeeps-heading-5-font-size">
                <span class="range-value"><?php echo esc_html($h5_font_size); ?>px</span>
                <label><?php _e('Heading 6', 'techbeeps') ?></label>
                <input data-id="heading_6_fs" type="range" min="5" max="80" step="1" value="<?php echo esc_attr($h6_font_size); ?>" class="techbeeps-heading-6-font-size">
                <span class="range-value"><?php echo esc_html($h6_font_size); ?>px</span>
            </div>
            <input type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr($this->value()); ?>" class="techbeeps-typography-hidden" />
        <?php
        }
    }

    class Techbeeps_Global_Button_Input_Control extends WP_Customize_Control
    {
        public $type = 'global_button_layout';
        public $labels =  [
            'top'    => 'Top',
            'right'  => 'Right',
            'bottom' => 'Bottom',
            'left'   => 'Left',
        ];
        public function render_content()
        {
            $value = $this->value() ?: '0px 0px 0px 0px';
            $val_items = explode('px', $value);
            $i = 0;
        ?>
            <div class="techbeeps-global-button-layout">
                <label><span class="customize-control-title"><?php echo esc_html($this->label); ?></span></label>
                <div class="techbeeps-global-input-control">
                    <?php foreach ($this->labels as $side => $label) : ?>
                        <div>
                            <input type="number" value="<?php echo esc_attr(trim($val_items[$i] ?? '0')); ?>"
                                class="global-side-input <?php echo esc_attr($this->id); ?>"
                                data-side="<?php echo esc_attr($side); ?>" />
                            <label><?php echo esc_html($label); ?></label>
                        </div>
                    <?php $i++;
                    endforeach; ?>
                </div>
            </div>
        <?php
        }
    }

    class Techbeeps_Global_Button_Layout_Styles extends WP_Customize_Control
    {
        public $type = 'global_button_layout_style';
        public $labels = [];
        public function render_content()
        {
        ?>
            <div class="techbeeps-range-control">
                <label><span class="techbeeps-control-title"><?php _e('Button Styles', 'techbeeps') ?></span></label>
                <div class="techbeeps-btn-all">
                    <label for="techbeeps-default">
                        <div class="techbeeps-btn techbeeps-btn-default">Button</div>
                    </label>
                    <label for="techbeeps-flat">
                        <div class="techbeeps-btn techbeeps-btn-flat">Button</div>
                    </label>
                    <label for="techbeeps-outline">
                        <div class="techbeeps-btn techbeeps-btn-outline"> Button</div>
                    </label>
                    <label for="techbeeps-rounded">
                        <div class="techbeeps-btn techbeeps-btn-rounded"> Button</div>
                    </label>
                    <label for="techbeeps-rounded_outline">
                        <div class="techbeeps-btn techbeeps-btn-rounded-outline"> Button</div>
                        <input type="radio" name="<?php echo esc_attr($this->id); ?>" <?php $this->link() ?> value="default" id="techbeeps-default" <?php checked($this->value(), 'default'); ?>>
                        <input type="radio" name="<?php echo esc_attr($this->id); ?>" <?php $this->link() ?> value="flat" id="techbeeps-flat" <?php checked($this->value(), 'flat'); ?>>
                        <input type="radio" name="<?php echo esc_attr($this->id); ?>" <?php $this->link() ?> value="rounded" id="techbeeps-rounded" <?php checked($this->value(), 'rounded'); ?>>
                        <input type="radio" name="<?php echo esc_attr($this->id); ?>" <?php $this->link() ?> value="outline" id="techbeeps-outline" <?php checked($this->value(), 'outline'); ?>>
                        <input type="radio" name="<?php echo esc_attr($this->id); ?>" <?php $this->link() ?> value="rounded_outline" id="techbeeps-rounded_outline" <?php checked($this->value(), 'rounded_outline'); ?>>
                </div>
            </div>
        <?php
        }
    }

    class Techbeeps_Global_Range_Control extends WP_Customize_Control
    {
        public $type = 'global_button_layout';
        public $labels = [];
        public function render_content()
        {
        ?>
            <div class="techbeeps-range-control">
                <label><span class="techbeeps-control-title"><?php esc_html($this->label); ?></span></label>
                <input <?php $this->link(); ?> data-id="btn-font-size" type="range" min="5" max="80" step="1" value="<?php echo esc_attr($this->value()); ?>" class="techbeeps-btn-font-size">
                <span class="range-value"><?php echo esc_html($this->value()); ?>px</span>
            </div>
        <?php
        }
    }

    class Techbeeps_Global_Sidebar_Layout_Control extends WP_Customize_Control
    {
        public $type = 'global_layout_icons';
        private function get_value($setting_id)
        {
            return $this->manager->get_setting($setting_id)->value();
        }
        public function render_content()
        {
            $layouts = ['no-sidebar' => 'No Sidebar', 'sidebar-left' => 'Left Sidebar', 'sidebar-right' => 'Right Sidebar'];
        ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <div class="global-sidebar-layout-icons">
                    <?php
                    foreach ($layouts as $value => $label): ?>
                        <div class="techbeeps-sidebar-style global-sidebar-layout-icon <?php echo esc_attr(($this->value() === $value) ? 'selected' : '') ?>"
                            data-value="<?php echo esc_attr($value); ?>"
                            title="<?php echo esc_attr($label); ?>">
                            <?php if ($value === 'sidebar-left') { ?>
                                <div class="techbeeps-layout-sidebar" bis_skin_checked="1">
                                    <div class="techbeeps-layout-line2" bis_skin_checked="1"></div>
                                </div>
                            <?php } ?>
                            <div class="techbeeps-layout-content techbeeps-layout-<?php echo esc_attr($value); ?>">
                                <div class="techbeeps-layout-line1"></div>
                                <div class="techbeeps-layout-line"></div>
                                <div class="techbeeps-layout-line"></div>
                                <div class="techbeeps-layout-line"></div>
                                <div class="techbeeps-layout-line"></div>
                            </div>
                            <?php if ($value === 'sidebar-right') { ?>
                                <div class="techbeeps-layout-sidebar" bis_skin_checked="1">
                                    <div class="techbeeps-layout-line2" bis_skin_checked="1"></div>
                                </div>
                            <?php } ?>
                        </div>
                    <?php endforeach; ?>
                </div>
                <input type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr($this->value()); ?>" />
            </label>
            <div class="techbeeps-container-style techbeeps-global-layout-control">
                <label for="techbeeps-container-style"> <span class="customize-control-title"><?php _e('Sidebar Style', 'techbeeps') ?> </span></label>
                <input type="radio" id="unboxed_sidebar" value="unboxed" name="techbeeps_sidebar_style" <?php checked(esc_attr($this->get_value('techbeeps_global_sidebar_style')), 'unboxed') ?>>
                <input type="radio" id="boxed_sidebar" value="boxed" name="techbeeps_sidebar_style" <?php checked(esc_attr($this->get_value('techbeeps_global_sidebar_style')), 'boxed') ?>>
                <input type="hidden" id="techbeeps_global_sidebar_style" value="<?php echo esc_attr($this->get_value('techbeeps_global_sidebar_style')); ?>" data-customize-setting-link="techbeeps_global_sidebar_style" />
                <div class="techbeeps-sidebar-style-labels">
                    <label for="unboxed_sidebar"><?php _e('Unboxed', 'techbeeps') ?></label>
                    <label for="boxed_sidebar"><?php _e('Boxed', 'techbeeps') ?></label>
                    <div class="techbeeps-toggle-slider"></div>
                </div>
            </div>
            <div class="techbeeps-range-control ">
                <label for="techbeeps-sidebar-width"><span class="techbeeps-control-title"><?php _e('Sidebar Width', 'techbeeps') ?></span></label>
                <div class="techbeeps-slider-wrapper">
                    <input type="range" id="techbeeps_sidebar_width" min="10" max="50" value="<?php echo esc_attr($this->get_value('techbeeps_sidebar_width')); ?>">
                    <input type="number" id="techbeeps_sidebar_width_value" value="<?php echo esc_attr($this->get_value('techbeeps_sidebar_width')); ?>" data-customize-setting-link="techbeeps_sidebar_width">
                    <span>px</span> <span class="techbeeps_sidebar_width_reset"><svg width="15px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path d="M22.719 12A10.719 10.719 0 0 1 1.28 12h.838a9.916 9.916 0 1 0 1.373-5H8v1H2V2h1v4.2A10.71 10.71 0 0 1 22.719 12z" />
                            <path fill="none" d="M0 0h24v24H0z" />
                        </svg>
                    </span>
                </div>
            </div>
<?php
        }
    }
}
