<?php

/**
 * Customizer Footer Layout Control
 *
 * @package Techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (class_exists('WP_Customize_Control')) {
    class Techbeeps_Footer_Layout_Control extends WP_Customize_Control
    {
        public $type = 'footer_layout_icons';
        public function enqueue()
        {
            wp_enqueue_script('techbeeps_footer_layout_controls-js', TECHBEEPS_URL . '/inc/custom-controls/js/footer-controls.js', ['jquery'], null, true);
            wp_enqueue_style('techbeeps_footer_layout_controls-css', TECHBEEPS_URL . '/inc/custom-controls/css/footer-controls.css');
        }
        public function render_content()
        {
?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <div class="footer-layout-icons">
                    <?php foreach ($this->choices as $value => $label): ?>
                        <div class="layout-icon <?php echo ($this->value() === $value) ? 'selected' : '' ?>"
                            data-value="<?php echo esc_attr($value); ?>"
                            title="<?php echo esc_attr($label); ?>">
                            <?php $parts = explode('-', $value);
                            foreach ($parts as $width) {
                                echo '<span style="flex:' . esc_attr(intval($width)) . '"></span>';
                            }
                            ?>
                        </div>
                    <?php endforeach; ?>
                </div>
                <input type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr($this->value()); ?>" />
            </label>
        <?php
        }
    }

    class Techbeeps_Footer_BoxModel_Control extends WP_Customize_Control
    {
        public $type = 'box_model';
        public function render_content()
        {
            $control_id = esc_attr($this->id);
            $labels =  [
                'top'    => 'Top',
                'right'  => 'Right',
                'bottom' => 'Bottom',
                'left'   => 'Left',
            ];
            $value = json_decode($this->value(), true);
            
        ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span></label>
            <div id="box-model-<?php echo esc_attr($control_id); ?>" class="techbeeps-global-input-control techbeeps-footer-controls">
                <?php foreach ($labels as $side => $label) : ?>
                    <div>
                        <input type="number" value="<?php echo esc_attr($value[$side] ?? '0'); ?>"
                            data-side="<?php echo esc_attr($side); ?>" />
                        <label><?php echo esc_html($label); ?></label>
                    </div>
                <?php
                endforeach; ?>
                <input type="hidden" id="<?php echo esc_attr($control_id); ?>-input" <?php $this->link(); ?> value="<?php echo esc_attr($this->value()); ?>" />
            </div>
<?php
        }
    }
}
