<?php

/**
 * Customizer Logo Size Control
 *
 * @package Techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (class_exists('WP_Customize_Control')) {
    class Techbeeps_Customizer_logo_size_Control extends WP_Customize_Control
    {
        public $type = 'range';
        public function render_content()
        {
?>
            <label>
                <span class="techbeeps-customize-control-title"><?php echo esc_html($this->label); ?></span>: <span id="<?php echo esc_attr($this->id); ?>_val"><?php echo esc_html($this->value()); ?>px</span>
                <input
                    type="range"
                    <?php $this->link(); ?>
                    value="<?php echo esc_attr($this->value()); ?>"
                    min="<?php echo esc_attr($this->input_attrs['min']); ?>"
                    max="<?php echo esc_attr($this->input_attrs['max']); ?>"
                    step="<?php echo esc_attr($this->input_attrs['step']); ?>"
                    oninput="document.getElementById('<?php echo esc_attr($this->id); ?>_val').innerText = this.value + 'px';" />
            </label>
<?php
        }
    }
}
