<?php

/**
 * Admin Page Meta Options
 *
 * @package TechBeep
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
// Register meta boxes for layout and sidebar
add_action('add_meta_boxes', function () {
    add_meta_box('techbeeps_layout_meta_box', __('Layout Options', 'techbeeps'), 'techbeeps_render_layout_meta_box', 'page', 'side', 'default');
});

// Render the UI for both layout and sidebar
function techbeeps_render_layout_meta_box($post)
{
    if (get_option('page_for_posts') == $post->ID) {
        _e("<div >This page cannot be customized from here.</div>", 'techbeeps');
        return; // Don't show on the posts page
    }

    wp_nonce_field('techbeeps_layout_nonce_action', 'techbeeps_layout_nonce');
    $page_layout = get_post_meta($post->ID, '_techbeeps_page_layout', true);
    $page_layout =  $page_layout === '' ? 'default' : $page_layout;
    $container_style = get_post_meta($post->ID, '_techbeeps_container_style', true);
    $container_style =  $container_style === '' ? 'Default' : $container_style;
    $sidebar_layout = get_post_meta($post->ID, '_techbeeps_sidebar_layout', true);
    $sidebar_layout =  $sidebar_layout === '' ? 'default' : $sidebar_layout;
    $sidebar_style = get_post_meta($post->ID, '_techbeeps_sidebar_style', true);
    $sidebar_style =  $sidebar_style === '' ? 'Default' : $sidebar_style;
    $disable_banner = get_post_meta($post->ID, '_techbeeps_disable_banner', true);
    $disable_header = get_post_meta($post->ID, '_techbeeps_disable_header', true);
    $disable_footer = get_post_meta($post->ID, '_techbeeps_disable_footer', true);

    $page_layouts = [
        'default' => 'Default',
        'container' => 'Container',
        'narrow' => 'Narrow',
        'full-width' => 'Full Width',
    ];
    $sidebar_layouts = [
        'default' => 'Default',
        'no-sidebar' => 'No Sidebar',
        'sidebar-left' => 'Left Sidebar',
        'sidebar-right' => 'Right Sidebar',
    ];

?>
    <strong><?php _e('Container Layout', 'techbeeps') ?></strong>
    <div class="techbeeps-layout-grid">
        <?php
        foreach ($page_layouts as $key => $label) { ?>
            <label class='techbeeps-layout-option'>
                <input type='radio' name='techbeeps_page_layout' value="<?php echo esc_attr($key) ?>" <?php echo checked($page_layout, $key);  ?>>
                <div class='techbeeps-layout-diagram'>
                    <div class="techbeeps-layout-<?php echo esc_attr($key); ?> global-layout-icon <?php echo  esc_attr($page_layout == $key ? 'selected' : '') ?>">
                        <div class="techbeeps-layout-line1"></div>
                        <div class="techbeeps-layout-line"></div>
                        <div class="techbeeps-layout-line"></div>
                        <div class="techbeeps-layout-line"></div>
                        <div class="techbeeps-layout-line"></div>
                    </div>
                </div>
                <div class='techbeeps-layout-label'> <?php echo esc_html($label); ?> </div>
            </label>
        <?php } ?>
    </div>
    <strong><?php _e('Container Style', 'techbeeps') ?></strong>
    <div class="techbeeps-swiper-toggle">
        <input type="radio" name="container_style" id="techbeeps-default1" value="Default" <?php checked($container_style, 'Default') ?>>
        <label for="techbeeps-default1"><?php _e('Default', 'techbeeps') ?></label>
        <input type="radio" name="container_style" id="techbeeps-unboxed1" value="Unboxed" <?php checked($container_style, 'Unboxed') ?>>
        <label for="techbeeps-unboxed1"><?php _e('Unboxed', 'techbeeps') ?></label>
        <input type="radio" name="container_style" id="techbeeps-boxed1" value="Boxed" <?php checked($container_style, 'Boxed') ?>>
        <label for="techbeeps-boxed1"><?php _e('Boxed', 'techbeeps') ?></label>
    </div>
    <div class="techbeeps-divider"></div>
    <strong><?php _e('Sidebar Layout', 'techbeeps') ?></strong>
    <div class="techbeeps-layout-grid">
        <?php
        foreach ($sidebar_layouts as $key => $label) { ?>
            <label class='techbeeps-layout-option'>
                <input type='radio' name='techbeeps_sidebar_layout' value="<?php echo esc_attr($key) ?>" <?php echo checked($sidebar_layout, $key);  ?>>
                <div class='techbeeps-layout-diagram'>
                    <?php if ($key == 'sidebar-left') { ?>
                        <div class="techbeeps-layout-sidebar">
                            <div class="techbeeps-layout-line2"></div>
                        </div>
                    <?php } ?>
                    <div class="techbeeps-layout-<?php echo esc_attr($key); ?> global-layout-icon <?php echo  esc_attr($sidebar_layout == $key ? 'selected' : '') ?>">
                        <div class="techbeeps-layout-line1"></div>
                        <div class="techbeeps-layout-line"></div>
                        <div class="techbeeps-layout-line"></div>
                        <div class="techbeeps-layout-line"></div>
                        <div class="techbeeps-layout-line"></div>
                    </div>
                    <?php if ($key == 'sidebar-right') { ?>
                        <div class="techbeeps-layout-sidebar">
                            <div class="techbeeps-layout-line2"></div>
                        </div>
                    <?php } ?>
                </div>
                <div class='techbeeps-layout-label'> <?php echo esc_html($label); ?> </div>
            </label>
        <?php } ?>
    </div>
    <strong><?php _e('Sidebar Style', 'techbeeps') ?></strong>
    <div class="techbeeps-swiper-toggle">
        <input type="radio" name="sidebar_style" id="techbeeps-default" value="Default" <?php checked($sidebar_style, 'Default') ?>>
        <label for="techbeeps-default"><?php _e('Default', 'techbeeps') ?></label>
        <input type="radio" name="sidebar_style" id="techbeeps-unboxed" value="Unboxed" <?php checked($sidebar_style, 'Unboxed') ?>>
        <label for="techbeeps-unboxed"><?php _e('Unboxed', 'techbeeps') ?></label>
        <input type="radio" name="sidebar_style" id="techbeeps-boxed" value="Boxed" <?php checked($sidebar_style, 'Boxed') ?>>
        <label for="techbeeps-boxed"><?php _e('Boxed', 'techbeeps') ?></label>
    </div>
    <div class="techbeeps-divider"></div>
    <div class="techbeeps-toggle-wrapper">
        <div class="techbeeps-toggle-item">
            <span class="techbeeps-toggle-label"><?php _e('Disable Header', 'techbeeps') ?></span>
            <label class="techbeeps-switch">
                <input type="checkbox" name="disable_header" <?php checked($disable_header, 'on') ?>>
                <span class="techbeeps-slider"></span>
            </label>
        </div>
        <div class="techbeeps-toggle-item">
            <span class="techbeeps-toggle-label"><?php _e('Disable Footer', 'techbeeps') ?></span>
            <label class="techbeeps-switch">
                <input type="checkbox" name="disable_footer" <?php checked($disable_footer, 'on') ?>>
                <span class="techbeeps-slider"></span>
            </label>
        </div>
        <div class="techbeeps-toggle-item">
            <span class="techbeeps-toggle-label"><?php _e('Allow Banner Area', 'techbeeps') ?></span>
            <label class="techbeeps-switch">
                <input type="checkbox" name="disable_banner" <?php checked($disable_banner, 'on') ?>>
                <span class="techbeeps-slider"></span>
            </label>
        </div>
    </div>
<?php
}

// Save layout and sidebar meta values
add_action('save_post', function ($post_id) {
    if (!isset($_POST['techbeeps_layout_nonce']) || !wp_verify_nonce($_POST['techbeeps_layout_nonce'], 'techbeeps_layout_nonce_action')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (isset($_POST['techbeeps_page_layout'])) {
        update_post_meta($post_id, '_techbeeps_page_layout', sanitize_text_field($_POST['techbeeps_page_layout']));
    }
    if (isset($_POST['techbeeps_sidebar_layout'])) {
        update_post_meta($post_id, '_techbeeps_sidebar_layout', sanitize_text_field($_POST['techbeeps_sidebar_layout']));
    }
    if (isset($_POST['container_style'])) {
        update_post_meta($post_id, '_techbeeps_container_style', sanitize_text_field($_POST['container_style']));
    }
    if (isset($_POST['sidebar_style'])) {
        update_post_meta($post_id, '_techbeeps_sidebar_style', sanitize_text_field($_POST['sidebar_style']));
    }
    if (isset($_POST['disable_header'])) {
        update_post_meta($post_id, '_techbeeps_disable_header', sanitize_text_field($_POST['disable_header']));
    } else {
        delete_post_meta($post_id, '_techbeeps_disable_header');
    }
    if (isset($_POST['disable_footer'])) {
        update_post_meta($post_id, '_techbeeps_disable_footer', sanitize_text_field($_POST['disable_footer']));
    } else {
        delete_post_meta($post_id, '_techbeeps_disable_footer');
    }
    if (isset($_POST['disable_banner'])) {
        update_post_meta($post_id, '_techbeeps_disable_banner', sanitize_text_field($_POST['disable_banner']));
    } else {
        delete_post_meta($post_id, '_techbeeps_disable_banner');
    }
});
 