<?php

/**
 * The template for displaying the header.
 *
 * @package techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <a href="#content" class="screen-reader-text"><?php esc_html_e('Skip to content', 'techbeeps'); ?></a>
    <?php wp_body_open(); ?>

    <div id="page" class="site">
        <?php
        // Check if Elementor header exists (Theme Builder)
        if (function_exists('elementor_theme_do_location')) {
            elementor_theme_do_location('header');
        }
        // Fallback: Default theme header
        else {
            $header_per = get_post_meta(get_the_ID(), '_techbeeps_disable_header', true) ?: 'off';
            if ($header_per !== 'on') {
                get_template_part('template-parts/header');
            }
        }
        ?>