<?php

/**
 * techbeeps functions and definitions
 *
 * @package techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

define('TECHBEEPS_VERSION', '1.1.0');
define('TECHBEEPS_DIR', get_template_directory());
define('TECHBEEPS_URL', get_template_directory_uri());
define('TECHBEEPS_ADMIN_URL', get_template_directory_uri() . '/assets/admin');
define('TECHBEEPS_ADMIN_DIR', get_template_directory() . '/assets/admin');
define('TECHBEEPS_ASSETS_URL', get_template_directory_uri() . '/assets');
define('TECHBEEPS_ASSETS_DIR', get_template_directory() . '/assets');

require_once TECHBEEPS_DIR . '/inc/customizer.php';
require_once TECHBEEPS_DIR . '/inc/admin/admin-page-meta.php';
require_once TECHBEEPS_DIR . '/inc/custom-functions.php';
require_once TECHBEEPS_DIR . '/inc/dynamic-styles.php';
function techbeeps_admin_assets($hook)
{
    // Admin CSS & JavaScript
    wp_enqueue_style('techbeeps-admin-style', get_template_directory_uri() . '/assets/admin/css/admin.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_script('techbeeps-admin-script', get_template_directory_uri() . '/assets/admin/js/admin.js', array('jquery'), TECHBEEPS_VERSION, true);
}
add_action('admin_enqueue_scripts', 'techbeeps_admin_assets');
// Enqueue scripts and styles
function techbeeps_scripts_styles()
{
    wp_enqueue_style('techbeeps-main-style', TECHBEEPS_ASSETS_URL . '/css/style.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-header-style', TECHBEEPS_ASSETS_URL . '/css/header.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-footer-style', TECHBEEPS_ASSETS_URL . '/css/footer.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-page-style', TECHBEEPS_ASSETS_URL . '/css/page.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-blog-style', TECHBEEPS_ASSETS_URL . '/css/blog.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-search-style', TECHBEEPS_ASSETS_URL . '/css/search.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-woocommerce-shop', TECHBEEPS_ASSETS_URL . '/css/woocommerce/woocommerce-shop.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-woocommerce-cart', TECHBEEPS_ASSETS_URL . '/css/woocommerce/woocommerce-cart.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-woocommerce-checkout', TECHBEEPS_ASSETS_URL . '/css/woocommerce/woocommerce-checkout.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-single-product', TECHBEEPS_ASSETS_URL . '/css/woocommerce/single-product.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-woocommerce-account', TECHBEEPS_ASSETS_URL . '/css/woocommerce/woocommerce-account.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-woocommerce', TECHBEEPS_ASSETS_URL . '/css/woocommerce/woocommerce.css', array(), TECHBEEPS_VERSION);
    wp_enqueue_style('techbeeps-style', get_stylesheet_uri(), array(), TECHBEEPS_VERSION);
    // Main JavaScript file
    wp_enqueue_script('techbeeps-script', TECHBEEPS_ASSETS_URL . '/js/main.js', array('jquery'), TECHBEEPS_VERSION, true);
    // Comment reply script
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'techbeeps_scripts_styles');
