<?php

/**
 * The template for displaying comments
 *
 * @package techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (post_password_required()) {
    return;
}

// Comment count
$comment_count = get_comments_number();
?>

<div id="comments" class="comments-area">
    <?php if (have_comments()) : ?>
        <h2 class="comments-title">
            <?php
            if ('1' === $comment_count) {
                esc_html_e('1 Comment', 'techbeeps');
            } else {
                printf(
                    esc_html(_nx('%1$s Comment', '%1$s Comments', $comment_count, 'comments title', 'techbeeps')),
                    number_format_i18n($comment_count)
                );
            }
            ?>
        </h2>

        <?php the_comments_navigation(); ?>

        <ol class="comment-list">
            <?php
            wp_list_comments([
                'style'       => 'ol',
                'short_ping' => true,
                'avatar_size' => 60,
                'callback'    => 'techbeeps_custom_comment_callback', // Custom comment display function
            ]);
            ?>
        </ol>

        <?php the_comments_navigation(); ?>

        <?php if (!comments_open()) : ?>
            <p class="no-comments"><?php esc_html_e('Comments are closed.', 'techbeeps'); ?></p>
        <?php endif; ?>
    <?php endif; ?>

    <?php
    // Custom comment form
    comment_form([
        'title_reply'          => __('Leave a Reply', 'techbeeps'),
        'title_reply_to'       => __('Leave a Reply to %s', 'techbeeps'),
        'cancel_reply_link'    => __('Cancel Reply', 'techbeeps'),
        'label_submit'         => __('Post Comment', 'techbeeps'),
        'comment_notes_before' => '<p class="comment-notes">' .
            __('Your email address will not be published. Required fields are marked *', 'techbeeps') .
            '</p>',
        'comment_field'        => '<p class="comment-form-comment">' .
            '<label for="comment">' . _x('Comment', 'noun', 'techbeeps') .
            ' <span class="required">*</span></label>' .
            '<textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" required="required"></textarea>' .
            '</p>',
        'fields'               => [
            'author' => '<p class="comment-form-author">' .
                '<label for="author">' . __('Name', 'techbeeps') .
                ' <span class="required">*</span></label>' .
                '<input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) .
                '" size="30" maxlength="245" required="required" /></p>',
            'email'  => '<p class="comment-form-email">' .
                '<label for="email">' . __('Email', 'techbeeps') .
                ' <span class="required">*</span></label>' .
                '<input id="email" name="email" type="email" value="' . esc_attr($commenter['comment_author_email']) .
                '" size="30" maxlength="100" aria-describedby="email-notes" required="required" /></p>',
            'url'    => '<p class="comment-form-url">' .
                '<label for="url">' . __('Website', 'techbeeps') . '</label>' .
                '<input id="url" name="url" type="url" value="' . esc_attr($commenter['comment_author_url']) .
                '" size="30" maxlength="200" /></p>',
            'cookies' => '<p class="comment-form-cookies-consent">' .
                '<input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"/>' .
                '<label for="wp-comment-cookies-consent">' .
                __('Save my name, email, and website in this browser for the next time I comment.', 'techbeeps') .
                '</label></p>',
        ],
        'class_submit'         => 'submit btn btn-primary',
        'submit_button'        => '<button name="%1$s" type="submit" id="%2$s" class="%3$s">%4$s</button>',
    ]);
    ?>
</div>

<?php
/**
 * Custom comment display callback
 */
function techbeeps_custom_comment_callback($comment, $args, $depth)
{
    $tag = ('div' === $args['style']) ? 'div' : 'li';
?>
    <<?php echo $tag; ?> id="comment-<?php comment_ID(); ?>" <?php comment_class(empty($args['has_children']) ? '' : 'parent', $comment); ?>>
        <article id="div-comment-<?php comment_ID(); ?>" class="comment-body">
            <footer class="comment-meta">
                <div class="comment-author vcard">
                    <?php
                    if (0 != $args['avatar_size']) {
                        echo get_avatar($comment, $args['avatar_size']);
                    }
                    ?>
                    <b class="fn"><?php echo get_comment_author_link($comment); ?></b>
                </div>
                <?php if ('0' == $comment->comment_approved) : ?>
                    <p class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.', 'techbeeps'); ?></p>
                <?php endif; ?>
                <div class="comment-metadata">
                    <a href="<?php echo esc_url(get_comment_link($comment, $args)); ?>">
                        <time datetime="<?php comment_time('c'); ?>">
                            <?php
                            printf(
                                __('%1$s at %2$s', 'techbeeps'),
                                get_comment_date('', $comment),
                                get_comment_time()
                            );
                            ?>
                        </time>
                    </a>
                    <?php edit_comment_link(__('Edit', 'techbeeps'), '<span class="edit-link">', '</span>'); ?>
                </div>


            </footer>

            <div class="comment-content">
                <?php comment_text(); ?>
            </div>

            <div class="reply">
                <?php
                comment_reply_link(array_merge($args, [
                    'add_below' => 'div-comment',
                    'depth'     => $depth,
                    'max_depth' => $args['max_depth'],
                    'before'    => '<div class="reply-link">',
                    'after'     => '</div>'
                ]));
                ?>
            </div>
        </article>
    <?php
}
