// assets/js/main.js

jQuery(document).ready(function ($) {
    function init() {
        var e = $(window).width();
        if (e <= 991) {
            $(".techbeeps-mobile-menu-canvas #mobile-menu .menu-item-has-children").append("<span>></span>");
             $('ul.sub-menu').addClass('hide');
        }
        $(".techbeeps-mobile-menu-canvas #mobile-menu .menu-item-has-children span").click(function () {
             $(this).siblings("ul").toggleClass('visible');
             $(this).toggleClass('open');
        });
    }
    init()

    let techbeepsToggle = $('#techbeeps-mobile-menu-toggle');
    let techbeeps_mob_can = $('#techbeeps-mobile-menu-canvas');
    let techbeepsBackdop = $('#techbeeps-canvas-backdrop');
    let techbeepsCloseBtn = $('.techbeeps-mobile-menu-close');

    // Function to trap focus
    function trapFocus(container) {
        container.on('keydown.focusTrap', function (e) {
            if (e.key !== 'Tab') return;

            let focusable = container.find('a, button, input, select, textarea, [tabindex]:not([tabindex="-1"])').filter(':visible');
            let firstEl = focusable.first()[0];
            let lastEl = focusable.last()[0];

            if (e.shiftKey) {
                // Shift + Tab
                if (document.activeElement === firstEl) {
                    e.preventDefault();
                    lastEl.focus();
                }
            } else {
                // Tab
                if (document.activeElement === lastEl) {
                    e.preventDefault();
                    firstEl.focus();
                }
            }
        });
    }

    function removeTrap(container) {
        container.off('keydown.focusTrap');
    }

    techbeepsToggle.on('click', function () {
        techbeeps_mob_can.addClass('open').removeAttr('inert');
        techbeepsBackdop.addClass('active');
        techbeepsToggle.attr('aria-expanded', 'true');

        // Move focus to close button
        techbeepsCloseBtn.focus();

        // Enable focus trap (rebuild focusable list each open)
        trapFocus(techbeeps_mob_can);
    });

    techbeepsCloseBtn.on('click', function () {
        techbeeps_mob_can.removeClass('open').attr('inert', '');
        techbeepsBackdop.removeClass('active');
        techbeepsToggle.attr('aria-expanded', 'false');
        techbeepsToggle.focus();

        // Remove trap
        removeTrap(techbeeps_mob_can);
    });

    techbeepsBackdop.on('click', function () {
        techbeeps_mob_can.removeClass('open').attr('inert', '');
        $(this).removeClass('active');
        techbeepsToggle.attr('aria-expanded', 'false');
        techbeepsToggle.focus();

        // Remove trap
        removeTrap(techbeeps_mob_can);
    });


    // focus jquery
    $(".menu-item a").on("focus", function () {
        element_main = $(this).parents("li")
        if (element_main.hasClass("menu-item-has-children")) {
            element_main.children("ul").addClass("focused-active");
        }
        const element = $(this).closest("li");
        if (element.hasClass("menu-item-has-children")) {
            const submenu = element.find(".sub-menu").first();
            submenu.removeClass("open-left"); // Reset
            const rect = submenu[0].getBoundingClientRect();
            const padding = 20;
            const willOverflowRight = rect.right > window.innerWidth - padding;
            if (willOverflowRight) {
                submenu.addClass("open-left");
            }
        } else {
            element.parent().find("ul").removeClass("focused-active");
        }

    });
    $("#primary-menu .menu-item a").on("blur", function () {
        $(this).parents("ul").removeClass("focused-active");
    });

});

// scroll
document.addEventListener('scroll', function () {
    var header = document.querySelector('.site-header');
    if (header) {
        if (window.scrollY > 100) {
            header.classList.add('scrolled');
        } else {
            header.classList.remove('scrolled');
        }
    }
});

document.addEventListener('DOMContentLoaded', function () {
    const tab = document.getElementById('tab-description');
    if (tab && tab === document.activeElement) {
        window.scrollTo(0, 0); // Optionally scroll back to top
    }
});

document.querySelectorAll("a, button").forEach(link => {
    link.addEventListener("click", function (e) {
        this.blur(); // removes focus
    });
});


function autoAdjustDropdowns() {
    const subMenus = document.querySelectorAll('.menu-item-has-children');
    subMenus.forEach(sub => {
        sub.addEventListener('mouseenter', () => {
            const submenu = sub.querySelector('.sub-menu');
            if (!submenu) return;
            submenu.classList.remove('open-left'); // Reset
            const rect = submenu.getBoundingClientRect();
            const padding = 20; // buffer from edge
            const willOverflowRight = rect.right > window.innerWidth - padding;
            if (willOverflowRight) {
                submenu.classList.add('open-left');
            }
        });
    });
}
autoAdjustDropdowns();
window.addEventListener('resize', autoAdjustDropdowns);
