<?php

/**
 * The template for displaying archive pages
 *
 * @package techbeeps
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.

}
$sidebar_layout = get_post_meta(get_the_ID(), '_techbeeps_sidebar_layout', true) ?: 'default';
get_header(); ?>

<div id="content" class="site-content">
    <div class="techbeeps-wrapper <?php echo esc_attr(techbeeps_get_layout_classes()); ?>">
        <?php
        if ($sidebar_layout === 'sidebar-left') {
            get_sidebar();
        } ?>
        <div id="primary" class="content-area primary">
            <main id="main" class="site-main archive">
                <?php if (have_posts()) : ?>
                    <header class="page-header">
                        <?php
                        the_archive_title('<h1 class="page-title">', '</h1>');
                        the_archive_description('<div class="archive-description">', '</div>');
                        ?>
                    </header><!-- .page-header -->
                <?php
                    /* Start the Loop */
                    while (have_posts()) :
                        the_post();
                        get_template_part('template-parts/content', get_post_type());

                    endwhile;

                    the_posts_navigation();

                else :

                    get_template_part('template-parts/content', 'none');

                endif;
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->
        <?php
        if ($sidebar_layout === 'sidebar-right') {
            get_sidebar();
        } ?>
    </div> <!-- techbeeps-wrapper -->
</div><!--content-->
<?php get_footer(); ?>