<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @package techbeeps
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

get_header();

?>
<div id="content" class="site-content">
    <div class="techbeeps-wrapper <?php echo esc_attr(techbeeps_get_layout_classes()); ?>">
        <div id="primary" class="content-area primary">
            <main id="main" class="site-main">
                <section class="error-404 not-found">
                    <header class="page-header">
                        <h1 class="page-title"><?php esc_html_e("404 Oops! That page can't be found.", 'techbeeps'); ?></h1>
                    </header><!-- .page-header -->

                    <div class="page-content">
                        <p><?php esc_html_e('It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'techbeeps'); ?></p>


                    </div><!-- .page-content -->
                </section><!-- .error-404 -->
            </main><!-- #main -->
        </div><!-- #primary -->
    </div> <!-- techbeeps-wrapper -->
</div><!--content-->
<?php get_footer(); ?>