<?php

function sarada_lite_fonts_url() {
    $fonts_url = '';
    
    $primary_font      = get_theme_mod( 'primary_font', 'Lato' );
    $ig_primary_font   = sarada_lite_is_google_font( $primary_font );
    $secondary_font    = get_theme_mod( 'secondary_font', 'Caveat' );
    $ig_secondary_font = sarada_lite_is_google_font( $secondary_font );

    $site_title_font    = get_theme_mod( 'site_title_font', array( 'font-family'=>'Caveat', 'variant'=>'700' ) );
    $ig_site_title_font = sarada_lite_is_google_font( $site_title_font['font-family'] );
        
    /* Translators: If there are characters in your language that are not
    * supported by respective fonts, translate this to 'off'. Do not translate
    * into your own language.
    */
    $primary    = _x( 'on', 'Primary Font: on or off', 'styled-fashion' );
    $secondary  = _x( 'on', 'Secondary Font: on or off', 'styled-fashion' );
    $site_title = _x( 'on', 'Site Title Font: on or off', 'styled-fashion' );    
    
    if ( 'off' !== $primary || 'off' !== $secondary || 'off' !== $site_title ) {
        
        $font_families = array();
     
        if ( 'off' !== $primary && $ig_primary_font ) {
            $primary_variant = sarada_lite_check_varient( $primary_font, 'regular', true );
            if( $primary_variant ){
                $primary_var = ':' . $primary_variant;
            }else{
                $primary_var = '';    
            }            
            $font_families[] = $primary_font . $primary_var;
        }
         
        if ( 'off' !== $secondary && $ig_secondary_font ) {
            $secondary_variant = sarada_lite_check_varient( $secondary_font, 'regular', true );
            if( $secondary_variant ){
                $secondary_var = ':' . $secondary_variant;    
            }else{
                $secondary_var = '';
            }
            $font_families[] = $secondary_font . $secondary_var;
        }

        if ( 'off' !== $site_title && $ig_site_title_font ) {
            
            if( ! empty( $site_title_font['variant'] ) ){
                $site_title_var = ':' . sarada_lite_check_varient( $site_title_font['font-family'], $site_title_font['variant'] );    
            }else{
                $site_title_var = '';
            }
            $font_families[] = $site_title_font['font-family'] . $site_title_var;
        }
        
        $font_families = array_diff( array_unique( $font_families ), array('') );
        
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),            
        );
        
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    if( get_theme_mod( 'ed_localgoogle_fonts', false ) ) {
        $fonts_url = sarada_lite_get_webfont_url( add_query_arg( $query_args, 'https://fonts.googleapis.com/css' ) );
    }
     
    return esc_url( $fonts_url );
}

function sarada_lite_body_classes( $classes ) {
    $widget_sticky       = get_theme_mod( 'ed_last_widget_sticky', false );
    $sidebar             = sarada_lite_sidebar( true );
    $ed_banner_section   = get_theme_mod( 'ed_banner_section', 'slider_banner' );
    $editor_options      = get_option( 'classic-editor-replace' );
    $allow_users_options = get_option( 'classic-editor-allow-users' );
    $layout              = get_theme_mod( 'home_layout', 'three' );
    
    // Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
    
    // Adds a class of custom-background-image to sites with a custom background image.
    if ( get_background_image() ) {
        $classes[] = 'custom-background-image';
    }
    
    // Adds a class of custom-background-color to sites with a custom background color.
    if ( get_background_color() != 'ffffff' ) {
        $classes[] = 'custom-background-color';
    }

    if( $widget_sticky && !( $sidebar == 'fullwidth-centered' || $sidebar == 'full-width' ) && !is_404() && !is_singular( 'blossom-portfolio' ) ) {
        $classes[] = 'widget-sticky';
    }

    if ( !sarada_lite_is_classic_editor_activated() || ( sarada_lite_is_classic_editor_activated() && $editor_options == 'block' ) || ( sarada_lite_is_classic_editor_activated() && $allow_users_options == 'allow' && has_blocks() ) ) {
        $classes[] = 'sarada-lite-has-blocks';
    }

    if( $ed_banner_section == 'no_banner' ) {
        $classes[] = 'banner-disabled';
    }

    if ( is_single() ) {        
        $classes[] = 'style-one underline';
    }

    if ( is_page() ) {        
        $classes[] = 'style-two underline';
    }

    if ( is_home() || ( is_archive() && !( sarada_lite_is_woocommerce_activated() && ( is_shop() || is_product_category() || is_product_tag() ) ) ) || is_search() ) {
        $classes[] = ( $layout == 'four' ) ? 'classic-layout' : 'grid-layout' ;
    }
    
    $classes[] = $sidebar;

	return $classes;
}

/**
* Header 
*/
function sarada_lite_header(){     
    $header       = get_theme_mod( 'header_layout', 'four' );
    $header_array = array( 'one', 'four' );
    
    if ( in_array( $header, $header_array ) ) {
        get_template_part('headers/' . $header);
    }
}  

function sarada_lite_header_menu_desc( $item_output, $item, $depth, $args ) {

    $header_layout = get_theme_mod( 'header_layout', 'one' );

    if ( 'primary' == $args->theme_location && $item->description && ( $header_layout == 'one' ) ){
        $item_output = '<span class="menu-subtitle">' . esc_html( $item->description ) . '</span>' . $item_output;
    }

    return $item_output;
} 

/**
 * Active Callback for Banner Slider
*/
function sarada_lite_banner_ac( $control ){
    $banner        = $control->manager->get_setting( 'ed_banner_section' )->value();
    $slider_layout = get_theme_mod( 'slider_layout', 'four' );
    $slider_type   = $control->manager->get_setting( 'slider_type' )->value();
    $control_id    = $control->id;
    
    if ( $control_id == 'header_image' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'header_video' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'external_header_video' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_title' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_subtitle' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_label' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_link' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_label_two' && $banner == 'static_banner' ) return true;
    if ( $control_id == 'banner_link_two' && $banner == 'static_banner' ) return true;
    
    if ( $control_id == 'slider_type' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_auto' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_loop' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_speed' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'slider_caption' && $banner == 'slider_banner' ) return true;          
    if ( $control_id == 'slider_readmore' && $banner == 'slider_banner' && $slider_layout == 'one'  ) return true;    
    if ( $control_id == 'slider_cat' && $banner == 'slider_banner' && $slider_type == 'cat' ) return true;
    if ( $control_id == 'no_of_slides' && $banner == 'slider_banner' && $slider_type == 'latest_posts' ) return true;
    if ( $control_id == 'slider_animation' && $banner == 'slider_banner' ) return true;
    if ( $control_id == 'banner_hr' && $banner == 'slider_banner' ) return true;
    
    return false;
}

/**
* Banner
*/
function sarada_lite_banner() {
    $header           = get_theme_mod('header_layout', 'four');

    if( is_front_page() || is_home() ) {
        $slider_layout    = get_theme_mod( 'slider_layout', 'four' );
        $ed_banner        = get_theme_mod( 'ed_banner_section', 'slider_banner' );
        $slider_type      = get_theme_mod( 'slider_type', 'latest_posts' );
        $slider_cat       = get_theme_mod( 'slider_cat' );
        $posts_per_page   = get_theme_mod( 'no_of_slides', 3 );
        $ed_caption       = get_theme_mod( 'slider_caption', true );
        $read_more        = get_theme_mod( 'slider_readmore', __( 'READ the ARTICLE', 'styled-fashion' ) );
        $banner_title     = get_theme_mod( 'banner_title', __( 'Find Your Best Holiday', 'styled-fashion' ) );
        $banner_subtitle  = get_theme_mod( 'banner_subtitle', __( 'Find great adventure holidays and activities around the planet.', 'styled-fashion' ) );
        $banner_label     = get_theme_mod( 'banner_label', __( 'Explore', 'styled-fashion' ) );
        $banner_link      = get_theme_mod( 'banner_link', '#' );
        $banner_label_two = get_theme_mod( 'banner_label_two', __( 'Learn More', 'styled-fashion' ) );
        $banner_link_two  = get_theme_mod( 'banner_link_two', '#' );
        
        if( $ed_banner == 'static_banner' && has_custom_header() ){ 
            if( has_header_video() ) {
                $custom_header_class = ' video-banner';
            }else{
                $custom_header_class = ' static-banner';
            } ?>
            <div id="banner_section" class="site-banner static-cta-banner style-one <?php echo esc_attr( $custom_header_class ); ?>">
                <div class="static-banner-wrap">
                    <?php 
                        the_custom_header_markup(); 
                        if( $ed_banner == 'static_banner' && ( $banner_title || $banner_subtitle || ( $banner_label && $banner_link ) ) ){
                            echo '<div class="banner-caption"><div class="container">';
                            if( $banner_title ) echo '<h2 class="banner-title">' . esc_html( $banner_title ) . '</h2>';
                            if( $banner_subtitle ) echo '<div class="banner-desc">' . wp_kses_post( $banner_subtitle ) . '</div>';
                            if( $banner_label && $banner_link ) echo '<a class="btn-readmore button-one" href="' . esc_url( $banner_link ) . '">' . esc_html( $banner_label ) . '</a>';
                            if( $banner_label_two && $banner_link_two ) echo '<a class="btn-readmore button-two" href="' . esc_url( $banner_link_two ) . '">' . esc_html( $banner_label_two ) . '</a>';
                            echo '</div></div>';
                        }
                    ?>
                </div>
            </div>
        <?php
        }elseif( $ed_banner == 'slider_banner' ){
            if( $slider_type == 'latest_posts' || $slider_type == 'cat' ){
            
                $args = array(
                    'post_status'         => 'publish',            
                    'ignore_sticky_posts' => true
                );
                
                if( $slider_type === 'cat' && $slider_cat ){
                    $args['post_type']      = 'post';
                    $args['cat']            = $slider_cat; 
                    $args['posts_per_page'] = -1;  
                }else{
                    $args['post_type']      = 'post';
                    $args['posts_per_page'] = $posts_per_page;
                }
                    
                $qry = new WP_Query( $args );
            
                if( $qry->have_posts() ){ ?>
                <div id="banner_section" class="site-banner style-<?php echo esc_attr( $slider_layout ); ?>">
                    <div class="item-wrap owl-carousel">
                        <?php while( $qry->have_posts() ){ $qry->the_post(); ?>
                            <div class="item has-single-img">
                                <div class="banner-img">
                                    <?php 
                                    if( has_post_thumbnail() ){
                                        the_post_thumbnail( 'sarada-blog', array( 'itemprop' => 'image' ) );    
                                    }else{
                                        sarada_lite_get_fallback_svg( 'sarada-blog' );
                                    } ?>
                                </div>
                                    
                                <?php 
                                if( $ed_caption ){                      
                                    echo '<div class="banner-caption">';
                                        sarada_lite_category();
                                        the_title( '<h2 class="banner-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                                        if( $read_more && $slider_layout != 'four' ) echo '<div class="button-wrap"><a href="' . esc_url( get_the_permalink() ) . '" class="btn-readmore">' . esc_html( $read_more ) . '</a></div>';                                            
                                    echo '</div>';
                                } ?>
                            </div>
                        <?php } ?>                        
                    </div>
                </div>
                <?php
                }
                wp_reset_postdata();
            }            
        } 
    }       
    if( $header == 'four' ) echo '</div>';
}

/**
* Dynamic Css
*/
function sarada_lite_dynamic_css() {
    
    $primary_font    = get_theme_mod( 'primary_font', 'Lato' );
    $primary_fonts   = sarada_lite_get_fonts( $primary_font, 'regular' );
    $secondary_font  = get_theme_mod( 'secondary_font', 'Caveat' );
    $secondary_fonts = sarada_lite_get_fonts( $secondary_font, '700' );

    $site_title_font      = get_theme_mod( 'site_title_font', array( 'font-family'=>'Caveat', 'variant'=>'700' ) );
    $site_title_fonts     = sarada_lite_get_fonts( $site_title_font['font-family'], $site_title_font['variant'] );
    $site_title_font_size = get_theme_mod( 'site_title_font_size', 36 );

    $font_size           = get_theme_mod( 'font_size', 18 );
    $secondary_font_size = get_theme_mod( 'secondary_font_size', 18 );
    
    $primary_color    = get_theme_mod( 'primary_color', '#d47a57' );
    $secondary_color  = get_theme_mod( 'secondary_color', '#d69f81' );
    $site_title_color = get_theme_mod( 'site_title_color', '#111111' );
    $site_logo_size   = get_theme_mod( 'site_logo_size', 250 );
    
    $rgb            = sarada_lite_hex2rgb( sarada_lite_sanitize_hex_color( $primary_color ) );
    $rgb_two        = sarada_lite_hex2rgb( sarada_lite_sanitize_hex_color( $secondary_color ) );
    $about_bg_image = get_theme_mod( 'about_bg_image', esc_url( get_template_directory_uri() . '/images/about-section-bg.png' ) );
     
    echo "<style type='text/css' media='all'>"; ?>
     
    .content-newsletter .blossomthemes-email-newsletter-wrapper.bg-img:after,
    .widget_blossomthemes_email_newsletter_widget .blossomthemes-email-newsletter-wrapper:after{
        <?php echo 'background: rgba(' . $rgb[0] . ', ' . $rgb[1] . ', ' . $rgb[2] . ', 0.8);'; ?>
    }
    
    /*Typography*/
    
    html{
        font-size   : <?php echo absint( $secondary_font_size ); ?>px;
    }
    
    body {
        font-family : <?php echo esc_html( $primary_fonts['font'] ); ?>;
        font-size   : <?php echo absint( $font_size ); ?>px;        
    }

    .about-section::before{
        background-image: url('<?php echo esc_url( $about_bg_image ); ?>');
    }
    
    .site-branding .site-title-wrap .site-title{
        font-size   : <?php echo absint( $site_title_font_size ); ?>px;
        font-family : <?php echo esc_html( $site_title_fonts['font'] ); ?>;
        font-weight : <?php echo esc_html( $site_title_fonts['weight'] ); ?>;
        font-style  : <?php echo esc_html( $site_title_fonts['style'] ); ?>;
    }
    
    .site-branding .site-title-wrap .site-title a{
        color: <?php echo sarada_lite_sanitize_hex_color( $site_title_color ); ?>;
    }

    :root {
	    --primary-font: <?php echo esc_html( $primary_fonts['font'] ); ?>;
	    --secondary-font: <?php echo esc_html( $secondary_fonts['font'] ); ?>;
	    --primary-color: <?php echo sarada_lite_sanitize_hex_color( $primary_color ); ?>;
	    --primary-color-rgb: <?php printf('%1$s, %2$s, %3$s', $rgb[0], $rgb[1], $rgb[2] ); ?>;
        --secondary-color: <?php echo sarada_lite_sanitize_hex_color( $secondary_color ); ?>;
        --secondary-color-rgb: <?php printf('%1$s, %2$s, %3$s', $rgb_two[0], $rgb_two[1], $rgb_two[2] ); ?>;
	}

    .custom-logo-link img{
	    width: <?php echo absint( $site_logo_size ); ?>px;
	    max-width: 100%;
	}
     
    <?php echo "</style>";
}

/**
 * Footer Bottom
 */
function sarada_lite_footer_bottom(){ ?>
    <div class="footer-b">
		<div class="container">
			<div class="site-info">            
            <?php
                sarada_lite_get_footer_copyright();
                echo esc_html__( ' Styled Fashion | Developed By ', 'styled-fashion' ); 
                echo '<a href="' . esc_url( 'https://blossomthemes.com/' ) .'" rel="nofollow" target="_blank">' . esc_html__( 'Blossom Themes', 'styled-fashion' ) . '</a>.';                
                printf( esc_html__( ' Powered by %s. ', 'styled-fashion' ), '<a href="'. esc_url( __( 'https://wordpress.org/', 'styled-fashion' ) ) .'" target="_blank">WordPress</a>' );
                if( function_exists( 'the_privacy_policy_link' ) ){
                    the_privacy_policy_link();
                }
            ?>               
            </div>
            <?php sarada_lite_footer_navigation(); ?>
            <button class="back-to-top">
                <svg xmlns="https://www.w3.org/2000/svg" viewBox="0 0 320 512"><path fill="currentColor" d="M58.427 225.456L124 159.882V456c0 13.255 10.745 24 24 24h24c13.255 0 24-10.745 24-24V159.882l65.573 65.574c9.373 9.373 24.569 9.373 33.941 0l16.971-16.971c9.373-9.373 9.373-24.569 0-33.941L176.971 39.029c-9.373-9.373-24.568-9.373-33.941 0L7.515 174.544c-9.373 9.373-9.373 24.569 0 33.941l16.971 16.971c9.372 9.373 24.568 9.373 33.941 0z"></path></svg>
            </button>
		</div>
	</div>
    <?php
}