<?php
// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/**
 *	After theme Setup Hook
 */
function styled_fashion_theme_setup() {
    /**
     * Make child theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    load_child_theme_textdomain( 'styled-fashion', get_stylesheet_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'styled_fashion_theme_setup', 100 );

/**
 * Enqueue scripts and styles.
 */
function styled_fashion_scripts() {
    $my_theme = wp_get_theme();
    $version  = $my_theme['Version'];
    $build    = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '/build' : '';
    $suffix   = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    wp_enqueue_style( 'sarada-lite', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'styled-fashion', get_stylesheet_directory_uri() . '/style.css', array( 'sarada-lite' ), $version );
    wp_enqueue_script( 'styled-fashion-custom', get_stylesheet_directory_uri() . '/js' . $build . '/custom' . $suffix . '.js', array( 'jquery' ), $version, true );

}
add_action('wp_enqueue_scripts', 'styled_fashion_scripts');

function styled_fashion_customize_register( $wp_customize ) {

    /** Move Background Image section to appearance panel */
    $wp_customize->get_section('colors')->panel              = 'appearance_settings';
    $wp_customize->get_section('colors')->priority           = 10;
    $wp_customize->get_section('background_image')->panel    = 'appearance_settings';
    $wp_customize->get_section('background_image')->priority = 15;

    /** Change defaults of color and typography */
    $wp_customize->get_setting('primary_color')->default   = '#d47a57';
    $wp_customize->get_setting('secondary_color')->default = '#d69f81';
    $wp_customize->get_setting('primary_font')->default    = 'Lato';
    $wp_customize->get_setting('secondary_font')->default  = 'Caveat';

    /** Move General Sidebar Layout section to Layout panel */
    $wp_customize->get_section( 'layout_settings' )->panel = 'layout_section';
    $wp_customize->get_section( 'layout_settings' )->title = __('General Sidebar Layout', 'styled-fashion');

    /** Layout Settings */
    $wp_customize->add_panel( 
        'layout_section',
        array(
            'priority'    => 45,
            'capability'  => 'edit_theme_options',
            'title'       => __( 'Layout Settings', 'styled-fashion' ),
            'description' => __( 'Change different page layout from here.', 'styled-fashion' ),
        ) 
    );

    /** Header Layout Settings */
    $wp_customize->add_section(
        'header_layout_settings',
        array(
            'title'    => __('Header Layout', 'styled-fashion'),
            'priority' => 10,
            'panel'    => 'layout_section',
        )
    );

    $wp_customize->add_setting(
        'header_layout',
        array(
            'default'           => 'four',
            'sanitize_callback' => 'sarada_lite_sanitize_radio'
        )
    );

    $wp_customize->add_control(
        new Sarada_Lite_Radio_Image_Control(
            $wp_customize,
            'header_layout',
            array(
                'section'     => 'header_layout_settings',
                'label'       => __('Header Layout', 'styled-fashion'),
                'description' => __('Choose the layout of the header for your site.', 'styled-fashion'),
                'choices'     => array(
                    'one'  => get_stylesheet_directory_uri() . '/images/header/one.png',
                    'four' => get_stylesheet_directory_uri() . '/images/header/four.png',
                )
            )
        )
    );

    /** Header Search */
    $wp_customize->add_setting(
        'ed_header_search',
        array(
            'default'           => true,
            'sanitize_callback' => 'sarada_lite_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
		new Sarada_Lite_Toggle_Control( 
			$wp_customize,
			'ed_header_search',
			array(
				'section'         => 'misc_settings',
				'label'           => __( 'Header Search', 'styled-fashion' ),
				'description'     => __( 'Enable to display search form in header.', 'styled-fashion' ),
				'active_callback' => 'styled_fashion_header_search_ac'
			)
		)
	);

    /** Shopping Cart */
	$wp_customize->add_setting(
		'ed_shopping_cart',
		array(
			'default'           => true,
			'sanitize_callback' => 'sarada_lite_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		new Sarada_Lite_Toggle_Control(
			$wp_customize,
			'ed_shopping_cart',
			array(
				'section'         => 'misc_settings',
				'label'           => __('Shopping Cart', 'styled-fashion'),
				'description'     => __('Enable to show Shopping cart in the header.', 'styled-fashion'),
				'active_callback' => 'styled_fashion_is_woocommerce_activated',
			)
		)
	);

    /** Slider Layout Settings */
    $wp_customize->add_section(
        'slider_layout_settings',
        array(
            'title'    => __('Slider Layout', 'styled-fashion'),
            'priority' => 20,
            'panel'    => 'layout_section',
        )
    );


    /** Page Sidebar layout */
    $wp_customize->add_setting( 
        'slider_layout', 
        array(
            'default'           => 'four',
            'sanitize_callback' => 'sarada_lite_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
		new Sarada_Lite_Radio_Image_Control(
			$wp_customize,
			'slider_layout',
			array(
				'section'     => 'slider_layout_settings',
				'label'       => __( 'Slider Layout', 'styled-fashion' ),
				'description' => __( 'Choose the layout of the slider for your site.', 'styled-fashion' ),
				'choices'     => array(
					'one'  => get_stylesheet_directory_uri() . '/images/slider/one.png',
					'four' => get_stylesheet_directory_uri() . '/images/slider/four.png',
				)
			)
		)
	);

    $wp_customize->add_section(
        'home_layout_settings',
        array(
            'title'    => __( 'Home Page Layout', 'styled-fashion' ),
            'priority' => 40,
            'panel'    => 'layout_section',
        )
    );
    
    /** Page Sidebar layout */
    $wp_customize->add_setting( 
        'home_layout', 
        array(
            'default'           => 'three',
            'sanitize_callback' => 'sarada_lite_sanitize_radio'
        ) 
    );
    
    $wp_customize->add_control(
		new Sarada_Lite_Radio_Image_Control(
			$wp_customize,
			'home_layout',
			array(
				'section'     => 'home_layout_settings',
				'label'       => __( 'Home Page Layout', 'styled-fashion' ),
				'description' => __( 'Choose the home page layout for your site.', 'styled-fashion' ),
				'choices'     => array(
                    'four'  => get_stylesheet_directory_uri() . '/images/home/four.png',
                    'three' => get_stylesheet_directory_uri() . '/images/home/three.png',
				)
			)
		)
	);
}
add_action( 'customize_register', 'styled_fashion_customize_register', 40 );

/**
 * Active Callback for Header Search.
*/
function styled_fashion_header_search_ac( $control ){
    
    $header_layout = $control->manager->get_setting( 'header_layout' )->value();
    
    if ( $header_layout != 'one' ) return true;
    
    return false;
}

/**
 * Active Callback for WooCommerce activation
 */
function styled_fashion_is_woocommerce_activated() {
	return class_exists( 'woocommerce' ) ? true : false;
}

/**
 * Parent Functions
*/
require get_stylesheet_directory() . '/inc/parent-functions.php';