<?php
/**
 * Template part for displaying posts navigation
 */

?>
<div class="clear-both"></div>
<div class="">
    <?php
    if ( is_archive() || is_home() || is_search() ) {
        /**
         * Checking WP-PagenaviPlugin exist
         */
        if ( function_exists( 'wp_pagenavi' ) ) {
            ?>
            <div class="sb-wp_pagenavi py-10 flex items-center justify-center">
                <?php
                wp_pagenavi();
                ?>
            </div>
            <?php
        } else {
            ?>
            <ul class="sb-posts-navigation flex justify-between items-center py-6 font-medium ">
                <li class="sb-nav-previous "><?php next_posts_link( esc_html__( '&larr; Previous', 'storybook' ) ); ?></li>
                <li class="sb-nav-next"><?php previous_posts_link( esc_html__( 'Next &rarr;', 'storybook' ) ); ?></li>
            </ul>
            <?php
        }
    }

    if ( is_single() ) {
        if ( is_attachment() ) {
            ?>
            <ul class="sb-post-navigation flex justify-between items-center py-10 font-medium">
                <li class="sb-nav-previous"><?php previous_image_link( false, __( '&larr; Previous', 'storybook' ) ); ?></li>
                <li class="sb-nav-next"><?php next_image_link( false, __( 'Next &rarr;', 'storybook' ) ); ?></li>
            </ul>
            <?php
        } else {
            ?>
            <ul class="sb-post-navigation flex justify-between items-center py-10 font-medium">
                <li class="sb-nav-previous"><?php previous_post_link( '%link', '<span class="meta-nav">' . __( '&larr; Previous', 'storybook' ) . '</span>' ); ?></li>
                <li class="sb-nav-next"><?php next_post_link( '%link', '<span class="meta-nav">' . __( 'Next &rarr;', 'storybook' ) . '</span>' ); ?></li>
            </ul>
            <?php
        }
    }
    ?>
</div>
