<?php
/**
 * Template part for displaying post archive
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('sb-card-archive prose prose-indigo'); ?>>

    <?php storybook_post_thumbnail( 'medium' ); ?>

    <div class="p-6 md:p-8">

        <?php
            if ( 'post' === get_post_type() ) :
                ?>
                <div class="entry-meta entry-categories">
                    <?php storybook_cats_list(); ?>
                </div>
                <?php
            endif;
        ?>

        <header class="entry-header">
            <?php
                the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
            ?>
        </header><!-- .entry-header -->

        <?php if ( ! get_theme_mod( 'storybook_hide_post_excerpt', false ) ) : ?>
            <div class="entry-summary">
                <?php the_excerpt(); ?>
            </div><!-- .entry-summary -->
        <?php endif; ?>

        <footer class="entry-footer space-x-4 items-center">
            <?php 
                storybook_posted_by();
                storybook_posted_on();
                storybook_comments_link();
                storybook_tags_list();
            ?>
        </footer><!-- .entry-footer -->
    </div>
	
</article><!-- #post-<?php the_ID(); ?> -->
