<?php
/**
 * The main template file
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();

$storybook_sidebar_class = '';
$storybook_content_class = '';
$storybook_columns_class = '';
if ( get_theme_mod( 'storybook_frontpage_sidebar_position', 'right' ) === 'left' ) {
	$storybook_content_class = 'lg:order-last lg:col-span-8';
	$storybook_sidebar_class = 'lg:col-span-3 lg:pr-10 lg:border-r sb-left-sidebar';
	$storybook_columns_class = 'md:grid-cols-2';
}
elseif ( get_theme_mod( 'storybook_frontpage_sidebar_position', 'right' ) === 'hide' ) {
	$storybook_content_class = 'lg:col-span-11';
	$storybook_columns_class = 'md:grid-cols-2 xl:grid-cols-3';
}
else {
	$storybook_content_class = 'lg:col-span-8';
	$storybook_sidebar_class = 'lg:col-span-3 lg:pl-10 lg:border-l';
	$storybook_columns_class = 'md:grid-cols-2';
}

?>

<?php if ( is_home() && is_front_page() && get_theme_mod( 'storybook_show_intro_section', false ) ) : ?>
	<section class="sb-intro-section border-b">
		<div class="2xl:container mx-auto px-4 py-44 text-center">
			<div class="max-w-4xl mx-auto">
				<h1 class="text-4xl 2xl:text-5xl font-bold mb-4 tracking-tight"><?php echo esc_html( get_theme_mod( 'storybook_intro_title', __( 'Move fast & Break things.', 'storybook' ) ) ); ?></h1>
				<p class="text-lg 2xl:text-xl"><?php echo esc_html( get_theme_mod( 'storybook_intro_desc', __( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Blanditiis commodi placeat eaque voluptatibus autem repellendus est assumenda vero. Autem, minima!', 'storybook' ) ) ); ?></p>
			</div>
		</div>
	</section>
<?php endif; ?>

	<main id="primary" class="site-main">
		<div class="2xl:container mx-auto px-4">
			<div class="grid grid-cols-1 lg:grid-cols-11 gap-10">
				<div class="sb-content-area py-8 lg:py-12 <?php echo esc_attr( $storybook_content_class ); ?>">
					<?php
					if ( have_posts() ) :

						if ( is_home() && ! is_front_page() ) :
							?>
							<header>
								<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
							</header>
							<?php
						endif;

						?>
						<div class="grid grid-cols-1 gap-10 <?php echo esc_attr( $storybook_columns_class ); ?>">
							<?php
							/* Start the Loop */
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content-archive', get_post_type() );
							endwhile;
							?>
						</div>
						<?php
						get_template_part( 'template-parts/navigation', 'none' );

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif;
					?>
				</div>

				<?php if ( get_theme_mod( 'storybook_frontpage_sidebar_position', 'right' ) !== 'hide' ) : ?>
				<div class="sb-sidebar py-8 lg:py-12 <?php echo esc_attr( $storybook_sidebar_class ); ?>">
					<?php get_sidebar(); ?>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</main><!-- #main -->

<?php
get_footer();
