<?php
/**
 * Custom template tags for this theme
 */

if ( ! function_exists( 'storybook_entry_footer' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags and comments.
	 */
	function storybook_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 'storybook' ) );
			if ( $categories_list ) {
				/* translators: 1: list of categories. */
				printf( '<span class="cat-links">' . esc_html__( 'Posted in %1$s', 'storybook' ) . '</span>', $categories_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}

			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'storybook' ) );
			if ( $tags_list ) {
				/* translators: 1: list of tags. */
				printf( '<span class="tags-links">' . esc_html__( 'Tagged %1$s', 'storybook' ) . '</span>', $tags_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			}
		}

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link(
				sprintf(
					wp_kses(
						/* translators: %s: post title */
						__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'storybook' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				)
			);
			echo '</span>';
		}

		edit_post_link(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Edit <span class="screen-reader-text">%s</span>', 'storybook' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post( get_the_title() )
			),
			'<span class="edit-link">',
			'</span>'
		);
	}
endif;

if ( ! function_exists( 'storybook_post_thumbnail' ) ) :
	function storybook_post_thumbnail( $storybook_thumb_size = 'regular' ) {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ) :
			?>

			<div class="post-thumbnail xl:-ml-12 xl:-mr-12 2xl:-ml-24 2xl:-mr-24">
				<?php the_post_thumbnail( 'storybook-featured-image' ); ?>
			</div><!-- .post-thumbnail -->

		<?php else : ?>

			<?php
			if ( 'medium' === $storybook_thumb_size ) {
				$storybook_size_name = 'storybook-featured-image-medium';
			} elseif ( 'small' === $storybook_thumb_size ) {
				$storybook_size_name = 'storybook-featured-image-small';
			} else {
				$storybook_size_name = 'storybook-featured-image';
			}
			?>

			<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
				<?php
					the_post_thumbnail(
						$storybook_size_name,
						array(
							'alt' => the_title_attribute(
								array(
									'echo' => false,
								)
							),
						)
					);
				?>
			</a>

			<?php
		endif; // End is_singular().
	}
endif;

if ( ! function_exists( 'wp_body_open' ) ) :
	/**
	 * Shim for sites older than 5.2.
	 *
	 * @link https://core.trac.wordpress.org/ticket/12563
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
endif;

// Get list of categories
if ( ! function_exists( 'storybook_cats_list' ) ) :
	function storybook_cats_list() {
		if ( 'post' === get_post_type() ) {
			if ( ! get_theme_mod( 'storybook_hide_post_cats', false ) ) {
				if ( get_the_category() ) {
					echo '<span class="cat-links flex space-x-4 items-center text-xs mb-2">';
					the_category( '&nbsp;' );
					echo '</span>';
				} else {
					return;
				}
			}
		}
	}
endif;

// Get post author
if ( ! function_exists( 'storybook_posted_by' ) ) :
	function storybook_posted_by() {
		if ( 'post' === get_post_type() ) {
			if ( ! get_theme_mod( 'storybook_hide_post_author', false ) ) {
				echo '<span class="byline text-xs">';
				echo '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>';
				echo '</span>';
			}
		}
	}
endif;

// Get post date
if ( ! function_exists( 'storybook_posted_on' ) ) :
	function storybook_posted_on() {
		if ( 'post' === get_post_type() ) {
			if ( ! get_theme_mod( 'storybook_hide_post_date', false ) ) {
				$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
				if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
					$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
				}
	
				$time_string = sprintf(
					$time_string,
					esc_attr( get_the_date( DATE_W3C ) ),
					esc_html( get_the_date() ),
					esc_attr( get_the_modified_date( DATE_W3C ) ),
					esc_html( get_the_modified_date() )
				);
	
				$posted_on_string = '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>';
	
				echo '<span class="posted-on text-xs">';
				echo wp_kses(
					$posted_on_string,
					array(
						'a'    => array(
							'class' => array(),
							'href'  => array(),
							'rel'   => array(),
						),
						'time' => array(
							'class'    => array(),
							'datetime' => array(),
						),
					)
				);
				echo '</span>';
			}
		}
	}
endif;

// Get comments link
if ( ! function_exists( 'storybook_comments_link' ) ) :
	function storybook_comments_link() {
		if ( ! get_theme_mod( 'storybook_hide_post_comment_link', false ) ) {
			if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
				echo '<span class="comments-link text-xs">';
				comments_popup_link(
					sprintf(
						wp_kses(
							/* translators: %s: post title */
							__( 'Leave a Comment<span class="screen-reader-text"> on %s</span>', 'storybook' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						wp_kses_post( get_the_title() )
					)
				);
				echo '</span>';
			}
		}
	}
endif;

// Get list of tags
if ( ! function_exists( 'storybook_tags_list' ) ) :
	function storybook_tags_list() {
		if ( 'post' === get_post_type() ) {
			if ( ! get_theme_mod( 'storybook_hide_post_tags', false ) ) {
				if ( get_the_category() ) {
					echo '<span class="tags-links items-center text-xs text-gray-500">';
					the_tags( '', ',&nbsp;' );
					echo '</span>';
				} else {
					return;
				}
			}
		}
	}
endif;
