<?php
/**
 * StoryBook Theme Customizer - Header options
 */

// Add Header Options panel.
$wp_customize->add_panel(
	'storybook_header_options',
	array(
		'capability'  => 'edit_theme_options',
		'description' => __( 'Change the Header Settings', 'storybook' ),
		'priority'    => 502,
		'title'       => __( 'Header Settings', 'storybook' ),
	)
);


// Add navigation bar settings section.
$wp_customize->add_section(
	'storybook_navbar_settings_section',
	array(
		'title' => __( 'Navigation Bar Settings', 'storybook' ),
		'panel' => 'storybook_header_options',
	)
);

$wp_customize->add_setting(
	'storybook_navbar_color',
	array(
		'default'           => 'white',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_radio',
	)
);
$wp_customize->add_control(
	'storybook_navbar_color',
	array(
		'type'     => 'radio',
		'label'    => esc_html__( 'Navbar Theme:', 'storybook' ),
		'section'  => 'storybook_navbar_settings_section',
		'settings' => 'storybook_navbar_color',
		'choices'  => array(
			'white'   => esc_html__( 'White (Default)', 'storybook' ),
			'light'   => esc_html__( 'Light', 'storybook' ),
			'dark'    => esc_html__( 'Dark', 'storybook' ),
		),
	)
);
