<?php
/**
 * StoryBook Theme Customizer - Frontpage options
 */

// Add Frontpage Options panel.
$wp_customize->add_panel(
	'storybook_frontpage_options',
	array(
		'capability'  => 'edit_theme_options',
		'description' => __( 'Add intro section on homepage.', 'storybook' ),
		'priority'    => 503,
		'title'       => __( 'Frontpage Settings', 'storybook' ),
        'active_callback' => function () {
            if ( 'page' == get_option( 'show_on_front' ) ) {
                return false;
            }
            return true;
        },
	)
);

// Add intro section.
$wp_customize->add_section(
	'storybook_intro_section',
	array(
		'title' => __( 'Intro Section', 'storybook' ),
		'panel' => 'storybook_frontpage_options',
	)
);

$wp_customize->add_setting(
	'storybook_show_intro_section',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_show_intro_section',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Show Intro Section on Frontpage', 'storybook' ),
		'section'  => 'storybook_intro_section',
		'settings' => 'storybook_show_intro_section',
	)
);

$wp_customize->add_setting(
    'storybook_intro_title',
    array(
        'default'           => esc_html__( 'Move fast & Break things.', 'storybook' ),
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'storybook_intro_title',
    array(
        'label'           => __( 'Enter Intro Section Title', 'storybook' ),
        'type'            => 'text',
        'section'         => 'storybook_intro_section',
        'setting'         => 'storybook_intro_title',
        'active_callback' => function () {
            if ( get_theme_mod( 'storybook_show_intro_section', false ) ) {
                return true;
            }
            return false;
        },
    )
);

$wp_customize->add_setting(
    'storybook_intro_desc',
    array(
        'default'           => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Blanditiis commodi placeat eaque voluptatibus autem repellendus est assumenda vero. Autem, minima!', 'storybook' ),
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'storybook_intro_desc',
    array(
        'label'           => __( 'Enter Intro Section Description', 'storybook' ),
        'type'            => 'textarea',
        'section'         => 'storybook_intro_section',
        'setting'         => 'storybook_intro_desc',
        'active_callback' => function () {
            if ( get_theme_mod( 'storybook_show_intro_section', false ) ) {
                return true;
            }
            return false;
        },
    )
);
