<?php
/**
 * StoryBook Theme Customizer - Design options
 */

// Add Design Options panel.
$wp_customize->add_panel(
	'storybook_design_options',
	array(
		'capability'  => 'edit_theme_options',
		'description' => __( 'Change the Design Settings', 'storybook' ),
		'priority'    => 501,
		'title'       => __( 'Design Settings', 'storybook' ),
	)
);

// Add sidebar positions section.
$wp_customize->add_section(
	'storybook_sidebar_positions_section',
	array(
		'title' => __( 'Sidebar Positions', 'storybook' ),
		'panel' => 'storybook_design_options',
	)
);

$wp_customize->add_setting(
	'storybook_frontpage_sidebar_position',
	array(
		'default'           => 'right',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_radio',
	)
);
$wp_customize->add_control(
	'storybook_frontpage_sidebar_position',
	array(
		'type'     => 'radio',
		'label'    => esc_html__( 'Frontpage Sidebar Position:', 'storybook' ),
		'section'  => 'storybook_sidebar_positions_section',
		'settings' => 'storybook_frontpage_sidebar_position',
		'choices'  => array(
			'right' => esc_html__( 'Sidebar on Right', 'storybook' ),
			'left'  => esc_html__( 'Sidebar on Left', 'storybook' ),
			'hide'  => esc_html__( 'Hide Sidebar', 'storybook' ),
		),
	)
);

$wp_customize->add_setting(
	'storybook_single_sidebar_position',
	array(
		'default'           => 'hide',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_radio',
	)
);
$wp_customize->add_control(
	'storybook_single_sidebar_position',
	array(
		'type'     => 'radio',
		'label'    => esc_html__( 'Single Post Sidebar Position:', 'storybook' ),
		'section'  => 'storybook_sidebar_positions_section',
		'settings' => 'storybook_single_sidebar_position',
		'choices'  => array(
			'right' => esc_html__( 'Sidebar on Right', 'storybook' ),
			'left'  => esc_html__( 'Sidebar on Left', 'storybook' ),
			'hide'  => esc_html__( 'Hide Sidebar', 'storybook' ),
		),
	)
);

$wp_customize->add_setting(
	'storybook_page_sidebar_position',
	array(
		'default'           => 'hide',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_radio',
	)
);
$wp_customize->add_control(
	'storybook_page_sidebar_position',
	array(
		'type'     => 'radio',
		'label'    => esc_html__( 'Page Sidebar Position:', 'storybook' ),
		'section'  => 'storybook_sidebar_positions_section',
		'settings' => 'storybook_page_sidebar_position',
		'choices'  => array(
			'right' => esc_html__( 'Sidebar on Right', 'storybook' ),
			'left'  => esc_html__( 'Sidebar on Left', 'storybook' ),
			'hide'  => esc_html__( 'Hide Sidebar', 'storybook' ),
		),
	)
);

$wp_customize->add_setting(
	'storybook_archive_sidebar_position',
	array(
		'default'           => 'right',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_radio',
	)
);
$wp_customize->add_control(
	'storybook_archive_sidebar_position',
	array(
		'type'        => 'radio',
		'label'       => esc_html__( 'Archive Sidebar Position:', 'storybook' ),
		'description' => esc_html__( 'Sidebar position for archive pages like category archives, author archives, tag archives, etc.', 'storybook' ),
		'section'     => 'storybook_sidebar_positions_section',
		'settings'    => 'storybook_archive_sidebar_position',
		'choices'     => array(
			'right' => esc_html__( 'Sidebar on Right', 'storybook' ),
			'left'  => esc_html__( 'Sidebar on Left', 'storybook' ),
			'hide'  => esc_html__( 'Hide Sidebar', 'storybook' ),
		),
	)
);



// Add primary color section.
$wp_customize->add_section(
	'storybook_color_options_section',
	array(
		'title' => __( 'Color Settings', 'storybook' ),
		'panel' => 'storybook_design_options',
	)
);

$wp_customize->add_setting(
	'storybook_primary_color',
	array(
		'default'              => '#4f46e5',
		'capability'           => 'edit_theme_options',
		'sanitize_callback'    => 'sanitize_hex_color',
		'sanitize_js_callback' => 'storybook_color_escaping_option_sanitize',
	)
);
$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'storybook_primary_color',
		array(
			'label'    => esc_html__( 'Select Primary Color', 'storybook' ),
			'section'  => 'storybook_color_options_section',
			'settings' => 'storybook_primary_color',
			'priority' => 1,
		)
	)
);



// Add font section.
$wp_customize->add_section(
	'storybook_fonts_section',
	array(
		'title' => __( 'Font Options', 'storybook' ),
		'panel' => 'storybook_design_options',
	)
);

$wp_customize->add_setting(
	'storybook_font_combo',
	array(
		'default'           => 'default',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_radio',
	)
);
$wp_customize->add_control(
	'storybook_font_combo',
	array(
		'type'     => 'radio',
		'label'    => esc_html__( 'Select Font Combination Option:', 'storybook' ),
		'section'  => 'storybook_fonts_section',
		'settings' => 'storybook_font_combo',
		'choices'  => array(
			'default' => esc_html__( 'Default', 'storybook' ),
			'option2' => esc_html__( 'Option 2', 'storybook' ),
			'option3' => esc_html__( 'Option 3', 'storybook' ),
			'option4' => esc_html__( 'Option 4', 'storybook' ),
			'option5' => esc_html__( 'Option 5', 'storybook' ),
		),
	)
);