<?php
/**
 * StoryBook Theme Customizer - Content options
 */

// Add content archive section.
$wp_customize->add_section(
	'storybook_content_settings_section',
	array(
		'title' => __( 'Content Settings', 'storybook' ),
		'priority'    => 504,
	)
);

$wp_customize->add_setting(
	'storybook_hide_post_cats',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_hide_post_cats',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Hide Post Categories', 'storybook' ),
		'section'  => 'storybook_content_settings_section',
		'settings' => 'storybook_hide_post_cats',
	)
);

$wp_customize->add_setting(
	'storybook_hide_post_excerpt',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_hide_post_excerpt',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Hide Post Excerpt', 'storybook' ),
		'section'  => 'storybook_content_settings_section',
		'settings' => 'storybook_hide_post_excerpt',
	)
);

$wp_customize->add_setting(
	'storybook_hide_post_author',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_hide_post_author',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Hide Post Author', 'storybook' ),
		'section'  => 'storybook_content_settings_section',
		'settings' => 'storybook_hide_post_author',
	)
);

$wp_customize->add_setting(
	'storybook_hide_post_date',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_hide_post_date',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Hide Post Date', 'storybook' ),
		'section'  => 'storybook_content_settings_section',
		'settings' => 'storybook_hide_post_date',
	)
);

$wp_customize->add_setting(
	'storybook_hide_post_comment_link',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_hide_post_comment_link',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Hide Comments Link', 'storybook' ),
		'section'  => 'storybook_content_settings_section',
		'settings' => 'storybook_hide_post_comment_link',
	)
);

$wp_customize->add_setting(
	'storybook_hide_post_tags',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_hide_post_tags',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Hide Post Tags', 'storybook' ),
		'section'  => 'storybook_content_settings_section',
		'settings' => 'storybook_hide_post_tags',
	)
);

$wp_customize->add_setting(
	'storybook_hide_post_thumbnail_single',
	array(
		'default'           => false,
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'storybook_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	'storybook_hide_post_thumbnail_single',
	array(
		'type'     => 'checkbox',
		'label'    => esc_html__( 'Hide Post Thumbnail displayed on Single Post', 'storybook' ),
		'section'  => 'storybook_content_settings_section',
		'settings' => 'storybook_hide_post_thumbnail_single',
	)
);


// Custom excerpt length.
$wp_customize->add_setting(
    'storybook_set_custom_excerpt_length',
    array(
        'default'           => false,
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'storybook_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'storybook_set_custom_excerpt_length',
    array(
        'type'     => 'checkbox',
        'label'    => __( 'Set custom length for excerpt?', 'storybook' ),
        'section'  => 'storybook_content_settings_section',
        'settings' => 'storybook_set_custom_excerpt_length',
        'active_callback' => function () {
            if ( get_theme_mod( 'storybook_hide_post_excerpt', false ) ) {
                return false;
            }
            return true;
        },
    )
);

$wp_customize->add_setting(
    'storybook_excerpt_length',
    array(
        'default'           => 30,
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'storybook_excerpt_length',
    array(
        'label'           => __( 'Enter Excerpt Length', 'storybook' ),
        'type'            => 'number',
        'section'         => 'storybook_content_settings_section',
        'setting'         => 'storybook_excerpt_length',
        'active_callback' => function () {
            if ( get_theme_mod( 'storybook_set_custom_excerpt_length', false ) ) {
                return true;
            }
            return false;
        },
    )
);