<?php
/**
 * StoryBook Theme Customizer
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function storybook_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'storybook_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'storybook_customize_partial_blogdescription',
			)
		);
	}

	include get_template_directory() . '/inc/customizer/design-options.php';
	include get_template_directory() . '/inc/customizer/header-options.php';
	include get_template_directory() . '/inc/customizer/frontpage-options.php';
	include get_template_directory() . '/inc/customizer/content-options.php';
	include get_template_directory() . '/inc/customizer/other-functions.php';
	include get_template_directory() . '/inc/class-storybook-customize-storybook-support.php';

	$wp_customize->get_section( 'header_image' )->panel               = 'storybook_header_options';
	$wp_customize->get_section( 'header_image' )->priority            = 999;
	$wp_customize->get_section( 'background_image' )->panel           = 'storybook_design_options';
	$wp_customize->get_section( 'background_image' )->priority        = 999;

	$wp_customize->get_control( 'header_textcolor' )->section = 'storybook_color_options_section';
	$wp_customize->get_control( 'background_color' )->section = 'storybook_color_options_section';

	// Logo height setting.
	$wp_customize->add_setting(
		'storybook_custom_logo_height',
		array(
			'default'           => false,
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'storybook_sanitize_checkbox',
		)
	);
	$wp_customize->add_control(
		'storybook_custom_logo_height',
		array(
			'type'     => 'checkbox',
			'label'    => __( 'Set custom height for Logo', 'storybook' ),
			'section'  => 'title_tagline',
			'settings' => 'storybook_custom_logo_height',
			'priority' => 8,
		)
	);
	$wp_customize->add_setting(
		'storybook_logo_height',
		array(
			'default'           => 60,
			'sanitize_callback' => 'absint',
		)
	);
	$wp_customize->add_control(
		'storybook_logo_height',
		array(
			'label'           => __( 'Enter logo height (in px)', 'storybook' ),
			'type'            => 'number',
			'section'         => 'title_tagline',
			'setting'         => 'storybook_logo_height',
			'priority'        => '9',
			'active_callback' => function () {
				if ( get_theme_mod( 'storybook_custom_logo_height', false ) ) {
					return true;
				}
				return false;
			},
		)
	);

	// Add Support Section.
	$wp_customize->add_section(
		'storybook_support_section',
		array(
			'title'    => __( 'StoryBook Support', 'storybook' ),
			'priority' => 999,
		)
	);
	$wp_customize->add_setting(
		'storybook_support_setting',
		array(
			'default'           => false,
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
		)
	);
	$wp_customize->add_control(
		new StoryBook_Customize_StoryBook_Support(
			$wp_customize,
			'storybook_support_setting',
			array(
				'label'   => __( 'StoryBook Support', 'storybook' ),
				'section' => 'storybook_support_section',
			)
		)
	);

}
add_action( 'customize_register', 'storybook_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function storybook_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function storybook_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function storybook_customize_preview_js() {
	wp_enqueue_script( 'storybook-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), STORYBOOK_VERSION, true );
}
add_action( 'customize_preview_init', 'storybook_customize_preview_js' );



/**
 * Storybook Custom css for customizer.
 *
 * @return void
 */
function storybook_styles_method() {

	$storybook_primary_color = get_theme_mod( 'storybook_primary_color', '#4f46e5' );
	$storybook_internal_css  = '';

	if ( '#4f46e5' !== $storybook_primary_color ) {
		$storybook_internal_css = "
			.prose-indigo a, .prose-indigo a code {
				color: {$storybook_primary_color};
			}
			.cat-links a, .byline a, .posted-on a, .comments-link a, .tags-links a {
				color: rgb(100, 116, 139);
			}
			.main-navigation a:hover, .sb-mobile-navigation a:hover,
			.main-navigation .current_page_item > a, .main-navigation .current-menu-item > a, .main-navigation .current_page_ancestor > a, .main-navigation .current-menu-ancestor > a,
			.site-title a:hover,
			.cat-links a:hover, .byline a:hover, .posted-on a:hover, .comments-link a:hover, .tags-links a:hover,
			.cat-links a,
			.widget a:hover,
			.comment-metadata a:hover, .comments-area .reply a:hover {
				color: {$storybook_primary_color};
			}
			[type='submit'] {
				background-color: {$storybook_primary_color};
			}
		";
	}

	wp_add_inline_style( 'storybook-style', $storybook_internal_css );

	if ( 'option2' === get_theme_mod( 'storybook_font_combo', 'default' ) ) {
		wp_dequeue_style( 'storybook-fonts' );
		wp_enqueue_style( 'storybook-fonts-option2', '//fonts.googleapis.com/css2?family=Open+Sans:wght@400;600;700&display=swap', array(), STORYBOOK_VERSION );

		$storybook_internal_font_css = "
		html, body {
			font-family: 'Open Sans', sans-serif;
		}
		";

		wp_add_inline_style( 'storybook-fonts-option2', $storybook_internal_font_css );
	}

	if ( 'option3' === get_theme_mod( 'storybook_font_combo', 'default' ) ) {
		wp_dequeue_style( 'storybook-fonts' );
		wp_enqueue_style( 'storybook-fonts-option3', '//fonts.googleapis.com/css2?family=Roboto:ital,wght@0,400;0,500;0,700;1,400&display=swap', array(), STORYBOOK_VERSION );

		$storybook_internal_font_css = "
		html, body {
			font-family: 'Roboto', sans-serif;
		}
		";

		wp_add_inline_style( 'storybook-fonts-option3', $storybook_internal_font_css );
	}

	if ( 'option4' === get_theme_mod( 'storybook_font_combo', 'default' ) ) {
		wp_dequeue_style( 'storybook-fonts' );
		wp_enqueue_style( 'storybook-fonts-option4', '//fonts.googleapis.com/css2?family=Crimson+Text:ital,wght@0,400;0,600;1,400;1,700&display=swap', array(), STORYBOOK_VERSION );

		$storybook_internal_font_css = "
		html {
			font-size: 18px;
		}
		html, body {
			font-family: 'Crimson Text', serif;
		}
		";

		wp_add_inline_style( 'storybook-fonts-option4', $storybook_internal_font_css );
	}

	if ( 'option5' === get_theme_mod( 'storybook_font_combo', 'default' ) ) {
		wp_dequeue_style( 'storybook-fonts' );
		wp_enqueue_style( 'storybook-fonts-option5', '//fonts.googleapis.com/css2?family=Lora:wght@400;500;600;700&display=swap', array(), STORYBOOK_VERSION );

		$storybook_internal_font_css = "
		html, body {
			font-family: 'Lora', serif;
		}
		";

		wp_add_inline_style( 'storybook-fonts-option5', $storybook_internal_font_css );
	}

}
add_action( 'wp_enqueue_scripts', 'storybook_styles_method' );



/**
 * Storybook_custom_logo_css
 *
 * @return void
 */
function storybook_custom_logo_css() {
	if ( get_theme_mod( 'storybook_custom_logo_height', false ) ) {
		?>
		<style type="text/css" id="custom-theme-css">
			.custom-logo { height: <?php echo esc_attr( get_theme_mod( 'storybook_logo_height', '60' ) ); ?>px; width: auto; }
		</style>
		<?php
	}
}
add_action( 'wp_head', 'storybook_custom_logo_css', 100 );