<?php
/**
 * Custom functions for content sections
 */

if ( ! function_exists( 'storybook_display_single_content_section' ) ) :
	function storybook_display_single_content_section() {
        while ( have_posts() ) :
            the_post();

            get_template_part( 'template-parts/content', get_post_type() );

            get_template_part( 'template-parts/navigation', 'none' );

            // If comments are open or we have at least one comment, load up the comment template.
            if ( comments_open() || get_comments_number() ) :
                comments_template();
            endif;

        endwhile; // End of the loop.
    }
endif;



if ( ! function_exists( 'storybook_display_single_content_layout_1' ) ) :
	function storybook_display_single_content_layout_1() {
        if ( get_theme_mod( 'storybook_single_sidebar_position', 'hide' ) === 'right' ) {
            ?>
            <div class="grid grid-cols-1 lg:grid-cols-11 gap-10 sb-content-layout-1">
                <div class="lg:col-span-8 py-8 lg:py-12 sb-content-area">
                    <div class="bg-white py-8 lg:py-12 px-8 shadow-md rounded-md">
                        <?php storybook_display_single_content_section(); ?>
                    </div>
                </div>
                <div class="lg:col-span-3 lg:pl-10 lg:border-l py-8 lg:py-12 sb-sidebar">
                    <?php get_sidebar(); ?>
                </div>
            </div>
            <?php
        }
        elseif ( get_theme_mod( 'storybook_single_sidebar_position', 'hide' ) === 'left' ) {
            ?>
            <div class="grid grid-cols-1 lg:grid-cols-11 gap-10 sb-content-layout-1">
                <div class="lg:col-span-8 py-8 lg:py-12 sb-content-area lg:order-last">
                    <div class="bg-white py-8 lg:py-12 px-8 shadow-md rounded-md">
                        <?php storybook_display_single_content_section(); ?>
                    </div>
                </div>
                <div class="lg:col-span-3 lg:pr-10 lg:border-r py-8 lg:py-12 sb-sidebar">
                    <?php get_sidebar(); ?>
                </div>
            </div>
            <?php
        }
        else {
            ?>
            <div class="py-8 lg:py-12 sb-content-layout-1 sb-allow-wide">
                <?php storybook_display_single_content_section(); ?>
            </div>
            <?php
        }
    }
endif;

if ( ! function_exists( 'storybook_display_single_content_layout_2' ) ) :
	function storybook_display_single_content_layout_2() {
        ?>
        <div class="grid grid-cols-1 lg:grid-cols-11 gap-10 sb-content-layout-2">
            <div class="lg:col-span-8 py-8 lg:py-12 sb-content-area">
                <?php storybook_display_single_content_section(); ?>
            </div>
            <div class="lg:col-span-3 lg:pl-10 lg:border-l py-8 lg:py-12 sb-sidebar">
                <?php get_sidebar(); ?>
            </div>
        </div>
        <?php
    }
endif;



if ( ! function_exists( 'storybook_display_page_content_section' ) ) :
	function storybook_display_page_content_section() {
        while ( have_posts() ) :
            the_post();

            get_template_part( 'template-parts/content', 'page' );

            // If comments are open or we have at least one comment, load up the comment template.
            if ( comments_open() || get_comments_number() ) :
                comments_template();
            endif;

        endwhile; // End of the loop.
    }
endif;

if ( ! function_exists( 'storybook_display_page_content_layout_1' ) ) :
	function storybook_display_page_content_layout_1() {
        if ( get_theme_mod( 'storybook_page_sidebar_position', 'hide' ) === 'right' ) {
            ?>
            <div class="grid grid-cols-1 lg:grid-cols-11 gap-10 sb-content-layout-1">
                <div class="lg:col-span-8 py-8 lg:py-12 sb-content-area">
                    <div class="bg-white py-8 lg:py-12 px-8 shadow-md rounded-md">
                        <?php storybook_display_page_content_section(); ?>
                    </div>
                </div>
                <div class="lg:col-span-3 lg:pl-10 lg:border-l py-8 lg:py-12 sb-sidebar">
                    <?php get_sidebar(); ?>
                </div>
            </div>
            <?php
        }
        elseif ( get_theme_mod( 'storybook_page_sidebar_position', 'hide' ) === 'left' ) {
            ?>
            <div class="grid grid-cols-1 lg:grid-cols-11 gap-10 sb-content-layout-1">
                <div class="lg:col-span-8 py-8 lg:py-12 sb-content-area lg:order-last">
                    <div class="bg-white py-8 lg:py-12 px-8 shadow-md rounded-md">
                        <?php storybook_display_page_content_section(); ?>
                    </div>
                </div>
                <div class="lg:col-span-3 lg:pr-10 lg:border-r py-8 lg:py-12 sb-sidebar">
                    <?php get_sidebar(); ?>
                </div>
            </div>
            <?php
        }
        else {
            ?>
            <div class="py-8 lg:py-12 sb-content-layout-1 sb-allow-wide">
                <?php storybook_display_page_content_section(); ?>
            </div>
            <?php
        }
    }
endif;

if ( ! function_exists( 'storybook_display_page_content_layout_2' ) ) :
	function storybook_display_page_content_layout_2() {
        ?>
        <div class="grid grid-cols-1 lg:grid-cols-11 gap-10 sb-content-layout-2">
            <div class="lg:col-span-8 py-8 lg:py-12 sb-content-area">
                <?php storybook_display_page_content_section(); ?>
            </div>
            <div class="lg:col-span-3 lg:pl-10 lg:border-l py-8 lg:py-12 sb-sidebar">
                <?php get_sidebar(); ?>
            </div>
        </div>
        <?php
    }
endif;