<?php
/**
 * StoryBook Category Dropdown Class
 *
 * @package StoryBook
 */

/**
 * StoryBook_Customize_StoryBook_Support
 */
class StoryBook_Customize_StoryBook_Support extends WP_Customize_Control {
	/**
	 * Render content.
	 *
	 * @return void
	 */
	public function render_content() {
		?>
		<div class="mb-theme-info">
			<a href="<?php echo esc_url( 'https://wordpress.org/support/theme/storybook/' ); ?>" target="_blank">
			<?php esc_html_e( 'Support Forum &rarr;', 'storybook' ); ?>
			</a>
			<a href="<?php echo esc_url( 'https://demo.odiethemes.com/storybook/' ); ?>" target="_blank">
			<?php esc_html_e( 'View Demo &rarr;', 'storybook' ); ?>
			</a>
		</div>

		<div class="mb-customizer-review-wrap">
			<h3><?php esc_html_e( 'Rate us 5-Star ', 'storybook' ); ?></h3>
			<p>
				<?php
					esc_html_e( 'If you can spare a minute, please help us by leaving a 5-star review on WordPress.org. By spreading the love, we can continue to develop new amazing features in the future, for free!', 'storybook' );
				?>
			</p>
			<p>
				<a href="https://wordpress.org/support/theme/storybook/reviews/?filter=5" target="_blank"><?php esc_html_e( 'Rate Us Now &rarr;', 'storybook' ); ?></a>
			</p>
		</div>
		<?php
	}
}
