<?php
/**
 * The header for our theme
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<?php do_action( 'storybook_before_page' ); ?>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'storybook' ); ?></a>

	<?php do_action( 'storybook_before_header' ); ?>

	<header id="masthead" class="site-header sb-site-header">
		<div class="2xl:container mx-auto px-4 py-8">
			<div class="flex space-x-4 items-center">
				<div class="site-branding lg:text-center flex-grow">
					<?php
					the_custom_logo();
					if ( is_front_page() && is_home() ) :
						?>
						<h1 class="site-title font-bold text-3xl tracking-tight"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
						<?php
					else :
						?>
						<p class="site-title font-bold text-3xl tracking-tight"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
						<?php
					endif;
					$storybook_description = get_bloginfo( 'description', 'display' );
					if ( $storybook_description || is_customize_preview() ) :
						?>
						<p class="site-description"><?php echo $storybook_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
					<?php endif; ?>
				</div><!-- .site-branding -->
				<button class="menu-toggle block lg:hidden" id="sb-mobile-menu-btn" aria-controls="primary-menu" aria-expanded="false">
					<svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
				</button>
			</div>
		</div>

		<?php the_custom_header_markup(); ?>

		<?php
			$storybook_nav_class = 'border-t';
			if ( get_theme_mod( 'storybook_navbar_color', 'white' ) === 'light' ) {
				$storybook_nav_class = 'border-t bg-gray-100';
			}
			elseif ( get_theme_mod( 'storybook_navbar_color', 'white' ) === 'dark' ) {
				$storybook_nav_class = 'bg-gray-900 dark-navbar';
			}
		?>
		
		<nav id="site-navigation" class="main-navigation <?php echo esc_attr( $storybook_nav_class ); ?>">
			<div class="2xl:container mx-auto px-4">
				<div class="hidden lg:flex justify-center">
					<?php
					wp_nav_menu(
						array(
							'theme_location' => 'menu-1',
							'menu_id'        => 'primary-menu',
						)
					);
					?>
				</div>
			</div>
		</nav><!-- #site-navigation -->

		<aside class="sb-mobile-navigation hidden relative z-50" id="sb-mobile-navigation">
			<div class="fixed inset-0 bg-gray-800 opacity-25" id="sb-menu-backdrop"></div>
			<div class="sb-mobile-menu fixed bg-white p-6 left-0 top-0 w-5/6 h-full overflow-scroll">
				<nav>
					<?php
					wp_nav_menu(
						array(
							'theme_location' => 'menu-1',
							'menu_id'        => 'primary-menu',
						)
					);
					?>
				</nav>
				<button type="button" class="text-gray-600 absolute right-4 top-4" id="sb-close-menu-btn">
					<svg
						class="w-5 h-5"
						fill="none"
						stroke="currentColor"
						viewBox="0 0 24 24"
						xmlns="http://www.w3.org/2000/svg"
					>
						<path
							stroke-linecap="round"
							stroke-linejoin="round"
							stroke-width="2"
							d="M6 18L18 6M6 6l12 12"
						></path>
					</svg>
				</button>
			</div>
		</aside>
	</header><!-- #masthead -->

	<?php do_action( 'storybook_after_header' ); ?>
