<?php
/**
 * StoryBook functions and definitions
 */

if ( ! defined( 'STORYBOOK_VERSION' ) ) {
	// Theme version.
	$storybook_theme = wp_get_theme();
	define( 'STORYBOOK_VERSION', $storybook_theme->get( 'Version' ) );
}

if ( ! function_exists( 'storybook_setup' ) ) :
	function storybook_setup() {
		
		load_theme_textdomain( 'storybook', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'storybook' ),
			)
		);

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'storybook_custom_background_args',
				array(
					'default-color' => 'F1F5F9',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		// Adding excerpt option box for pages as well.
		add_post_type_support( 'page', 'excerpt' );

		// Add support for wide alignments
		add_theme_support( 'align-wide' );

		// Add theme support for responsive embeds.
		add_theme_support( 'responsive-embeds' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add editor style
		add_editor_style( get_template_directory_uri() . '/css/editor-style.css' );

		// Add support for experimental cover block spacing.
		add_theme_support( 'custom-spacing' );

		// Define image sizes for theme.
		add_image_size( 'storybook-featured-image', 1020, 680, true );
		add_image_size( 'storybook-featured-image-medium', 525, 350, true );
		add_image_size( 'storybook-featured-image-small', 150, 120, true );
	}
endif;
add_action( 'after_setup_theme', 'storybook_setup' );

// Set the content width in pixels
function storybook_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'storybook_content_width', 840 );
}
add_action( 'after_setup_theme', 'storybook_content_width', 0 );

// Register widget area.
function storybook_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'storybook' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'storybook' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h4 class="widget-title text-lg font-bold">',
			'after_title'   => '</h4>',
		)
	);
}
add_action( 'widgets_init', 'storybook_widgets_init' );

// Enqueue scripts and styles.
function storybook_scripts() {
	wp_enqueue_style( 'storybook-fonts', '//fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap', array(), STORYBOOK_VERSION );
	wp_enqueue_style( 'storybook-style', get_stylesheet_uri(), array(), STORYBOOK_VERSION );
	wp_style_add_data( 'storybook-style', 'rtl', 'replace' );

	wp_enqueue_script( 'storybook-scripts', get_template_directory_uri() . '/js/theme.js', array(), STORYBOOK_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'storybook_scripts' );

// Implement the Custom Header feature.
require get_template_directory() . '/inc/custom-header.php';

// Custom template tags for this theme.
require get_template_directory() . '/inc/template-tags.php';

// Functions which enhance the theme by hooking into WordPress.
require get_template_directory() . '/inc/template-functions.php';

// Functions for content sections
require get_template_directory() . '/inc/content-functions.php';

// Customizer additions.
require get_template_directory() . '/inc/customizer.php';

// Load Jetpack compatibility file.
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}
