<?php
/**
 * The template for displaying archive pages
 */

get_header();

$storybook_sidebar_class = '';
$storybook_content_class = '';
$storybook_columns_class = '';
if ( get_theme_mod( 'storybook_archive_sidebar_position', 'right' ) === 'left' ) {
	$storybook_content_class = 'lg:order-last lg:col-span-8';
	$storybook_sidebar_class = 'lg:col-span-3 lg:pr-10 lg:border-r sb-left-sidebar';
	$storybook_columns_class = 'md:grid-cols-2';
}
elseif ( get_theme_mod( 'storybook_archive_sidebar_position', 'right' ) === 'hide' ) {
	$storybook_content_class = 'lg:col-span-11';
	$storybook_columns_class = 'md:grid-cols-2 xl:grid-cols-3';
}
else {
	$storybook_content_class = 'lg:col-span-8';
	$storybook_sidebar_class = 'lg:col-span-3 lg:pl-10 lg:border-l';
	$storybook_columns_class = 'md:grid-cols-2';
}
?>

	<main id="primary" class="site-main">
		<div class="2xl:container mx-auto px-4">
			<div class="grid grid-cols-1 lg:grid-cols-11 gap-10">
				<div class="sb-content-area py-8 lg:py-12 <?php echo esc_attr( $storybook_content_class ); ?>">
					<?php if ( have_posts() ) : ?>

						<header class="page-header mb-8">
							<?php
							if ( is_category() ) {
								?>
								<h1 class="page-title font-bold text-3xl tracking-tight cat-title"><?php single_cat_title(); ?></h1>
								<?php
							} elseif ( is_tag() ) {
								?>
								<h1 class="page-title font-bold text-3xl tracking-tight tag-title"><?php single_tag_title(); ?></h1>
								<?php
							} elseif ( is_author() ) {
								?>
								<h1 class="page-title font-bold text-3xl tracking-tight tag-title"><?php the_author(); ?></h1>
								<?php
							} else {
								the_archive_title( '<h1 class="page-title font-bold text-3xl tracking-tight">', '</h1>' );
							}
							the_archive_description( '<div class="archive-description text-gray-600">', '</div>' );
							?>
						</header><!-- .page-header -->
						
						<div class="grid grid-cols-1 gap-10 <?php echo esc_attr( $storybook_columns_class ); ?>">

							<?php
							/* Start the Loop */
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content-archive', get_post_type() );

							endwhile;
							?>
						</div>
						<?php
						get_template_part( 'template-parts/navigation', 'none' );

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif;
					?>
				</div>
				<?php if ( get_theme_mod( 'storybook_archive_sidebar_position', 'right' ) !== 'hide' ) : ?>
				<div class="sb-sidebar py-8 lg:py-12 <?php echo esc_attr( $storybook_sidebar_class ); ?>">
					<?php get_sidebar(); ?>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</main><!-- #main -->

<?php
get_footer();
