<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package started
 */

if ( ! function_exists( 'started_paging_nav' ) ) :
/**
 * Display navigation to next/previous set of posts when applicable.
 */
function started_paging_nav() {
	// Don't print empty markup if there's only one page.
	if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
		return;
	}
	?>
	<nav class="navigation paging-navigation" role="navigation">
		<h3 class="screen-reader-text"><?php _e( 'Posts navigation', 'started' ); ?></h3>
		<div class="nav-links">

			<?php if ( get_next_posts_link() ) : ?>
			<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'started' ) ); ?></div>
			<?php endif; ?>

			<?php if ( get_previous_posts_link() ) : ?>
			<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'started' ) ); ?></div>
			<?php endif; ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'started_post_nav' ) ) :
/**
 * Display navigation to next/previous post when applicable.
 */
function started_post_nav() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<nav class="navigation post-navigation" role="navigation">
		<h3 class="screen-reader-text"><?php _e( 'Post navigation', 'started' ); ?></h3>
		<div class="nav-links">
			<?php
				previous_post_link( '<div class="nav-previous">%link</div>', _x( '<span class="meta-nav">&larr;</span> %title', 'Previous post link', 'started' ) );
				next_post_link(     '<div class="nav-next">%link</div>',     _x( '%title <span class="meta-nav">&rarr;</span>', 'Next post link',     'started' ) );
			?>
		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'started_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function started_posted_on() {
	$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string .= '<time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	printf( __( '<span class="posted-on">Posted on %1$s</span><span class="byline"> by %2$s</span>', 'started' ),
		sprintf( '<a href="%1$s" rel="bookmark">%2$s</a>',
			esc_url( get_permalink() ),
			$time_string
		),
		sprintf( '<span class="author vcard"><a class="url fn n" href="%1$s">%2$s</a></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_html( get_the_author() )
		)
	);
}
endif;

function started_part_author_info() {
?>
	<div class="post-author-info">
		<div class="author-avatar">
			<?php echo get_avatar( get_the_author_meta( 'user_email' ), 80 ); ?>
		</div><!-- .author-avatar -->
		<div class="author-description">
			<h3 class="author-description-title"><?php printf( esc_attr__( 'About %s', 'started' ), get_the_author() ); ?></h3>
			<p class="author-bio"><?php the_author_meta( 'description' ); ?></p>
			<div class="author-link">
				<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>">
					<?php printf( __( 'View all posts by %s', 'started' ).'<span class="meta-nav">&rarr;</span>', get_the_author() ); ?>
				</a>
			</div><!-- .author-link -->
		</div><!-- .author-description -->
	</div><!-- .post-author-info -->
<?php	
} // started_part_author_info();

//Breadcrumb
function started_breadcrumb() {
	if (!is_home()) {
		echo '<a href="';
		echo esc_url(home_url());
		echo '">';
		_e( 'Home', 'started' );
		echo "</a> &raquo; ";
		if (is_category() || is_single()) {
			single_cat_title();
			if (is_single()) {
			the_category(', ');
				echo " &raquo; ";
				the_title();
			}
		} elseif (is_page()) {
			echo the_title();
		}
		  elseif (is_tag()) {
			echo 'Posts tagged with "'; 
			single_tag_title();
			echo '"'; }
		elseif (is_day()) {echo "Archive for "; the_time(' F jS, Y');}
		elseif (is_month()) {echo "Archive for "; the_time(' F, Y');}
		elseif (is_year()) {echo "Archive for "; the_time(' Y');}
		elseif (is_author()) {echo "Author Archive";}
		elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "Blog Archives";}
		elseif (is_search()) {echo "Search Results";}
	}
}
/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function started_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'started_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,

			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'started_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so started_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so started_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in started_categorized_blog.
 */
function started_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'started_categories' );
}
add_action( 'edit_category', 'started_category_transient_flusher' );
add_action( 'save_post',     'started_category_transient_flusher' );
