<?php

/**
 * started functions and definitions
 *
 * @package started
 */
/**
 * Set the content width based on the theme's design and stylesheet.
 */
if (!defined('_S_VERSION')) {
	// Replace the version number of the theme on each release.
	define('_S_VERSION', '1.2.0');
}
if (!function_exists('started_setup')) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function started_setup()
	{
		global $content_width;

		if (!isset($content_width)) {
			$content_width = 640; /* pixels */
		}
		/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on started, use a find and replace
	 * to change 'started' to the name of your theme in all the template files
	 */
		load_theme_textdomain('started', get_template_directory() . '/languages');


		// Add default posts and comments RSS feed links to head.
		add_theme_support('automatic-feed-links');

		/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
		add_theme_support('title-tag');





		// Load default block styles.
		add_theme_support('align-wide');
		add_theme_support('wp-block-styles');

		add_theme_support('editor-styles');
		add_theme_support('block-templates');
		add_editor_style('editor-style.css');
		// Add support for responsive embeds.
		add_theme_support('responsive-embeds');

		/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
		add_theme_support('post-thumbnails');

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(array(
			'primary' => __('Primary Menu', 'started'),
			'footer-menu' => __('Footer Menu', 'started')
		));

		// Setup the WordPress core custom background feature.
		add_theme_support('custom-background', apply_filters('started_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		)));

		/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
		add_theme_support(
			'html5',
			array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
				'navigation-widgets',
			)
		);

		/*
 * Enable support for Post Formats.
 *
 * See: https://wordpress.org/documentation/article/post-formats/
 */
		add_theme_support(
			'post-formats',
			array(
				'aside',
				'image',
				'video',
				'quote',
				'link',
				'gallery',
				'audio',
			)
		);

		// Add theme support for Custom Logo.
		add_theme_support(
			'custom-logo',
			array(
				'width'      => 250,
				'height'     => 250,
				'flex-width' => true,
			)
		);
	}
endif; // started_setup
add_action('after_setup_theme', 'started_setup');

/**
 * Register widgetized area and update sidebar with default widgets.
 */
function started_widgets_init()
{
	register_sidebar(array(
		'name'          => __('Sidebar', 'started'),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	));
}
add_action('widgets_init', 'started_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function started_scripts()
{
	wp_enqueue_style('started-style', get_stylesheet_uri(), array(), _S_VERSION);

	//wp_enqueue_script( 'started-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );
	// Register the html5 shiv.
	wp_register_script('html5', get_theme_file_uri('/js/html5shiv.js'), array(), '20161020');
	wp_script_add_data('html5', 'conditional', 'lt IE 9');
	wp_enqueue_script('started-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), _S_VERSION, array('in_footer' => true));

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'started_scripts');

/**
 * Implement the Custom Header feature.
 */
//require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * SVG icons functions and filters.
 */
require get_parent_theme_file_path('/inc/icon-functions.php');

/**
 * Block Patterns.
 */
require get_template_directory() . '/inc/block-patterns.php';
