<?php
    $editorpick_title       = sofi_blog_get_option( 'editorpick_title' );
    $editorpick_subtitle       = sofi_blog_get_option( 'editorpick_subtitle' );
    $editorpick_top_content_type     = sofi_blog_get_option( 'editorpick_top_content_type' );
    $enable_top_category     = sofi_blog_get_option( 'editorpick_top_category_enable' );
    $enable_top_content     = sofi_blog_get_option( 'editorpick_top_content_enable' );
    $enable_top_author     = sofi_blog_get_option( 'editorpick_top_author_enable' );
    $enable_top_posted_on     = sofi_blog_get_option( 'editorpick_top_posted_on_enable' );
    $editorpick_content_type     = sofi_blog_get_option( 'editorpick_content_type' );
    $enable_category     = sofi_blog_get_option( 'editorpick_category_enable' );
    $enable_content     = sofi_blog_get_option( 'editorpick_content_enable' );
    $enable_author     = sofi_blog_get_option( 'editorpick_author_enable' );
    $enable_posted_on     = sofi_blog_get_option( 'editorpick_posted_on_enable' );
    $number_of_editorpick_items  = sofi_blog_get_option( 'number_of_editorpick_items' );
    $editorpick_category = sofi_blog_get_option( 'editorpick_category' );
    $header_font_size = sofi_blog_get_option( 'editorpick_font_size');
    $number_of_editorpick_column = sofi_blog_get_option('number_of_editorpick_column');
    $content_align = sofi_blog_get_option('editorpick_content_align');
    $excerpt_length =sofi_blog_get_option( 'editorpick_excerpt_length');
    $excerpt_top_length =sofi_blog_get_option( 'editorpick_top_excerpt_length');
    $editorpick_post_count =sofi_blog_get_option( 'editorpick_post_count_enable');
    $homepage_layout_options = sofi_blog_get_option('homepage_design_layout_options');

    $see_more_txt     = sofi_blog_get_option( 'editorpick_see_all_txt' );
    $see_more_url     = sofi_blog_get_option( 'editorpick_see_all_url' );

    for( $i=1; $i<=$number_of_editorpick_items; $i++ ) :
        $editorpick_page_posts[] = absint(sofi_blog_get_option( 'editorpick_page_'.$i ) );
        $editorpick_post_posts[] = absint(sofi_blog_get_option( 'editorpick_post_'.$i ) );
    endfor;

?> 
<style>
    <?php if ($header_font_size != 0): ?>
        #editorpick .section-title{
            font-size:<?php echo esc_attr($header_font_size); ?>px;
        }
    <?php endif ?>
</style> 
<div class="editorpick-main-wrapper">
    <div class="editorpick-top-wrapper inner clear ">
        <?php 
            $editorpick_top_id = sofi_blog_get_option( 'editorpick_top_post' );
            $args = array (
                'post_type'     => 'post',
                'posts_per_page' => 1,
                'p' => $editorpick_top_id,
                'ignore_sticky_posts' => true, 
            ); 
            $the_query = new WP_Query( $args );

            // The Loop
            while ( $the_query->have_posts() ) : $the_query->the_post();
            ?>
                <article class="<?php echo has_post_thumbnail() ? 'has-post-thumbnail' : 'no-post-thumbnail' ; ?>">
                    <div class="editorpick-top-item-wrapper">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="post-featured-image">
                                <div class="featured-image" style="background-image: url('<?php the_post_thumbnail_url();?>');">
                                    <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>
                                    <?php $homepage_video_url = get_post_meta( get_the_ID(), 'sophi-blog-video-url', true ); ?>
                                    <?php if (!empty($homepage_video_url)): ?>
                                       <a href="<?php the_permalink();?>"> <div class="homepage-video-icon"><i class="fa fa-play"></i></div></a>
                                    <?php endif ?>
                                </div><!-- .featured-image -->
                            </div>
                        <?php endif; ?>
                        <?php if ($homepage_layout_options !='home-main'): ?>
                            <div class="entry-container <?php echo esc_attr($content_align); ?>">
                                <?php if ( ($editorpick_top_content_type !== 'editorpick_top_page') && ($enable_top_category==true)) : ?>
                                    <div class="entry-meta">
                                        <?php sophi_blog_entry_meta(); ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                                </header>
                                <?php if ((($enable_top_posted_on==true) || ($enable_top_author==true))) : ?>
                                    <div class="entry-meta">
                                        <?php 
                                            if (($enable_top_posted_on==true)) {
                                                sophi_blog_posted_on();
                                            } 
                                            if (($enable_top_author==true)) {
                                                sophi_blog_author();
                                            }
                                         ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                                <?php if (($enable_top_content==true)) : ?>
                                    <div class="entry-content">
                                        <?php
                                            $excerpt = sophi_blog_the_excerpt( $excerpt_top_length );
                                            echo wp_kses_post( wpautop( $excerpt ) );
                
                                        ?>
                                    </div><!-- .entry-content -->
                                <?php endif; ?>  
                            </div><!-- .entry-container -->
                        <?php endif; ?>
                    </div>
                </article>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
    </div>
    <div class="editorpick-wrapper clear col-<?php echo esc_attr($number_of_editorpick_column); ?>">
        <?php 
            $args = array (

                'posts_per_page' =>absint( $number_of_editorpick_items ),              
                'post_type' => 'post',
                'post_status' => 'publish',
                'paged' => 1,
                'ignore_sticky_posts' => true, 
                );
                if ( absint( $editorpick_category ) > 0 ) {
                    $args['cat'] = absint( $editorpick_category );
                }
            $loop = new WP_Query($args);                        
            if ( $loop->have_posts() ) :
                $i=0;  
                while ($loop->have_posts()) : $loop->the_post(); $i++;?>      
                <?php $col_class='';
                if ($i==1) {
                     $col_class='full-width';
                 } else{
                    $col_class='half-width';
                 } ?>  
                    <article class="<?php echo $col_class; ?> <?php echo has_post_thumbnail() ? 'has-post-thumbnail' : 'no-post-thumbnail' ; ?>">
                        <?php if ($editorpick_post_count==true && !has_post_thumbnail()): ?>
                            <span class="post-num"><?php echo $i; ?></span>
                        <?php endif ?>
                        <div class="editorpick-item-wrapper">
                            <?php if (has_post_thumbnail()) : ?>
                                <div class="post-featured-image">
                                    <div class="featured-image" style="background-image: url('<?php the_post_thumbnail_url();?>');">
                                        <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>
                                        <?php $homepage_video_url = get_post_meta( get_the_ID(), 'sophi-blog-video-url', true ); ?>
                                        <?php if (!empty($homepage_video_url)): ?>
                                           <a href="<?php the_permalink();?>"> <div class="homepage-video-icon"><i class="fa fa-play"></i></div></a>
                                        <?php endif ?>
                                        <?php if ($editorpick_post_count==true): ?>
                                            <span class="post-num"><?php echo $i; ?></span>
                                        <?php endif ?>
                                    </div><!-- .featured-image -->
                                </div>
                            <?php endif; ?>
                            <div class="entry-container <?php echo esc_attr($content_align); ?>">
                                <?php if ( ($editorpick_content_type !== 'editorpick_page') && ($enable_category==true)) : ?>
                                    <div class="entry-meta">
                                        <?php sophi_blog_entry_meta(); ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                                </header>
                                <?php if ((($enable_posted_on==true) || ($enable_author==true))) : ?>
                                    <div class="entry-meta">
                                        <?php 
                                            if (($enable_posted_on==true)) {
                                                sophi_blog_posted_on();
                                            } 
                                            if (($enable_author==true)) {
                                                sophi_blog_author();
                                            }
                                         ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                                <?php if (($enable_content==true)) : ?>
                                    <div class="entry-content">
                                        <?php
                                            $excerpt = sophi_blog_the_excerpt( $excerpt_length );
                                            echo wp_kses_post( wpautop( $excerpt ) );
                                        ?>
                                    </div><!-- .entry-content -->
                                <?php endif; ?>  
                            </div><!-- .entry-container -->
                        </div>
                    </article>

                <?php endwhile;?>
            <?php endif; ?>
            <?php wp_reset_postdata(); ?>
    </div>
</div>
